/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.data.cache.CacheType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandlerInterface;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.network.message.CacheDataSyncMessage;
import de.markusbordihn.easynpc.network.message.PresetExportClientMessage;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public class ClientNetworkMessageHandler
implements ClientNetworkMessageHandlerInterface {
    @Override
    public void syncCacheData(UUID uuid, ServerPlayer serverPlayer, CacheType cacheType, CompoundTag data) {
        if (uuid == null || serverPlayer == null || cacheType == null || data == null) {
            return;
        }
        NetworkHandler.sendToPlayer(new CacheDataSyncMessage(uuid, cacheType, data), serverPlayer);
    }

    @Override
    public void exportClientPreset(UUID uuid, String name, ServerPlayer serverPlayer) {
        if (uuid == null || name == null || name.isEmpty() || serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.exportPresetData();
        log.info("Exporting preset for {} to {}", (Object)easyNPC.getEntity().m_7755_().getString(), (Object)serverPlayer.m_7755_().getString());
        NetworkHandler.sendToPlayer(new PresetExportClientMessage(uuid, easyNPC.getEntity().m_7755_().getString(), easyNPC.getEasyNPCSkinData().getSkinModel(), name, compoundTag), serverPlayer);
    }
}

