/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.message.CacheDataSyncMessage;
import de.markusbordihn.easynpc.network.message.ChangeSpawnerSettingMessage;
import de.markusbordihn.easynpc.network.message.DialogButtonActionMessage;
import de.markusbordihn.easynpc.network.message.ImportPresetMessage;
import de.markusbordihn.easynpc.network.message.MessageActionEventChange;
import de.markusbordihn.easynpc.network.message.MessageAdvancedTrading;
import de.markusbordihn.easynpc.network.message.MessageBasicTrading;
import de.markusbordihn.easynpc.network.message.MessageEntityAttributeChange;
import de.markusbordihn.easynpc.network.message.MessageEntityBaseAttributeChange;
import de.markusbordihn.easynpc.network.message.MessageModelEquipmentVisibilityChange;
import de.markusbordihn.easynpc.network.message.MessageModelLockRotationChange;
import de.markusbordihn.easynpc.network.message.MessageModelPoseChange;
import de.markusbordihn.easynpc.network.message.MessageModelPositionChange;
import de.markusbordihn.easynpc.network.message.MessageModelRotationChange;
import de.markusbordihn.easynpc.network.message.MessageModelVisibilityChange;
import de.markusbordihn.easynpc.network.message.MessageNameChange;
import de.markusbordihn.easynpc.network.message.MessageObjectiveAdd;
import de.markusbordihn.easynpc.network.message.MessageObjectiveRemove;
import de.markusbordihn.easynpc.network.message.MessageOpenConfiguration;
import de.markusbordihn.easynpc.network.message.MessageOpenDialogButtonEditor;
import de.markusbordihn.easynpc.network.message.MessageOpenDialogEditor;
import de.markusbordihn.easynpc.network.message.MessageOpenDialogTextEditor;
import de.markusbordihn.easynpc.network.message.MessagePoseChange;
import de.markusbordihn.easynpc.network.message.MessagePositionChange;
import de.markusbordihn.easynpc.network.message.MessagePresetExport;
import de.markusbordihn.easynpc.network.message.MessagePresetExportWorld;
import de.markusbordihn.easynpc.network.message.MessageProfessionChange;
import de.markusbordihn.easynpc.network.message.MessageRemoveDialog;
import de.markusbordihn.easynpc.network.message.MessageRemoveDialogButton;
import de.markusbordihn.easynpc.network.message.MessageRemoveNPC;
import de.markusbordihn.easynpc.network.message.MessageRespawnNPC;
import de.markusbordihn.easynpc.network.message.MessageSaveDialog;
import de.markusbordihn.easynpc.network.message.MessageSaveDialogButton;
import de.markusbordihn.easynpc.network.message.MessageSaveDialogSet;
import de.markusbordihn.easynpc.network.message.MessageScaleChange;
import de.markusbordihn.easynpc.network.message.MessageSkinChange;
import de.markusbordihn.easynpc.network.message.MessageTradingTypeChange;
import de.markusbordihn.easynpc.network.message.PresetExportClientMessage;
import de.markusbordihn.easynpc.network.message.TriggerActionEventMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class NetworkHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String PROTOCOL_VERSION = "21";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("easy_npc", "network"), () -> "21", "21"::equals, "21"::equals);
    private static int id = 0;

    private NetworkHandler() {
    }

    private static <M> void registerServerNetworkMessageHandler(Class<M> networkMessage, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, ServerPlayer> handler) {
        NetworkHandler.registerNetworkMessageHandler(networkMessage, encoder, decoder, handler, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <M> void registerClientNetworkMessageHandler(Class<M> networkMessage, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, ServerPlayer> handler) {
        NetworkHandler.registerNetworkMessageHandler(networkMessage, encoder, decoder, handler, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <M> void registerNetworkMessageHandler(Class<M> networkMessage, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, ServerPlayer> handler, NetworkDirection networkDirection) {
        INSTANCE.registerMessage(id++, networkMessage, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                handler.accept(message, context.getSender());
                context.setPacketHandled(true);
            });
        }, Optional.of(networkDirection));
    }

    public static void registerNetworkHandler(FMLCommonSetupEvent event) {
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udde3 Register Easy NPC", (Object)INSTANCE, (Object)PROTOCOL_VERSION);
        event.enqueueWork(() -> {
            NetworkHandler.registerServerNetworkHandler();
            NetworkHandler.registerClientNetworkHandler();
        });
    }

    public static void registerClientNetworkHandler() {
        NetworkHandler.registerClientNetworkMessageHandler(CacheDataSyncMessage.class, CacheDataSyncMessage::encode, CacheDataSyncMessage::decode, CacheDataSyncMessage::handle);
        NetworkHandler.registerClientNetworkMessageHandler(PresetExportClientMessage.class, PresetExportClientMessage::encode, PresetExportClientMessage::decode, PresetExportClientMessage::handle);
    }

    public static void registerServerNetworkHandler() {
        NetworkHandler.registerServerNetworkMessageHandler(ChangeSpawnerSettingMessage.class, ChangeSpawnerSettingMessage::encode, ChangeSpawnerSettingMessage::decode, ChangeSpawnerSettingMessage::handle);
        NetworkHandler.registerServerNetworkMessageHandler(TriggerActionEventMessage.class, TriggerActionEventMessage::encode, TriggerActionEventMessage::decode, TriggerActionEventMessage::handle);
        NetworkHandler.registerServerNetworkMessageHandler(DialogButtonActionMessage.class, DialogButtonActionMessage::encode, DialogButtonActionMessage::decode, DialogButtonActionMessage::handle);
        NetworkHandler.registerServerNetworkMessageHandler(ImportPresetMessage.class, ImportPresetMessage::encode, ImportPresetMessage::decode, ImportPresetMessage::handle);
        INSTANCE.registerMessage(id++, MessageActionEventChange.class, MessageActionEventChange::encode, MessageActionEventChange::decode, MessageActionEventChange::handle);
        INSTANCE.registerMessage(id++, MessageAdvancedTrading.class, MessageAdvancedTrading::encode, MessageAdvancedTrading::decode, MessageAdvancedTrading::handle);
        INSTANCE.registerMessage(id++, MessageBasicTrading.class, MessageBasicTrading::encode, MessageBasicTrading::decode, MessageBasicTrading::handle);
        INSTANCE.registerMessage(id++, MessageEntityAttributeChange.class, MessageEntityAttributeChange::encode, MessageEntityAttributeChange::decode, MessageEntityAttributeChange::handle);
        INSTANCE.registerMessage(id++, MessageEntityBaseAttributeChange.class, MessageEntityBaseAttributeChange::encode, MessageEntityBaseAttributeChange::decode, MessageEntityBaseAttributeChange::handle);
        INSTANCE.registerMessage(id++, MessageModelLockRotationChange.class, MessageModelLockRotationChange::encode, MessageModelLockRotationChange::decode, MessageModelLockRotationChange::handle);
        INSTANCE.registerMessage(id++, MessageModelPoseChange.class, MessageModelPoseChange::encode, MessageModelPoseChange::decode, MessageModelPoseChange::handle);
        INSTANCE.registerMessage(id++, MessageModelPositionChange.class, MessageModelPositionChange::encode, MessageModelPositionChange::decode, MessageModelPositionChange::handle);
        INSTANCE.registerMessage(id++, MessageModelEquipmentVisibilityChange.class, MessageModelEquipmentVisibilityChange::encode, MessageModelEquipmentVisibilityChange::decode, MessageModelEquipmentVisibilityChange::handle);
        INSTANCE.registerMessage(id++, MessageModelVisibilityChange.class, MessageModelVisibilityChange::encode, MessageModelVisibilityChange::decode, MessageModelVisibilityChange::handle);
        INSTANCE.registerMessage(id++, MessageNameChange.class, MessageNameChange::encode, MessageNameChange::decode, MessageNameChange::handle);
        INSTANCE.registerMessage(id++, MessageObjectiveAdd.class, MessageObjectiveAdd::encode, MessageObjectiveAdd::decode, MessageObjectiveAdd::handle);
        INSTANCE.registerMessage(id++, MessageObjectiveRemove.class, MessageObjectiveRemove::encode, MessageObjectiveRemove::decode, MessageObjectiveRemove::handle);
        INSTANCE.registerMessage(id++, MessageOpenConfiguration.class, MessageOpenConfiguration::encode, MessageOpenConfiguration::decode, MessageOpenConfiguration::handle);
        INSTANCE.registerMessage(id++, MessageOpenDialogEditor.class, MessageOpenDialogEditor::encode, MessageOpenDialogEditor::decode, MessageOpenDialogEditor::handle);
        INSTANCE.registerMessage(id++, MessageOpenDialogButtonEditor.class, MessageOpenDialogButtonEditor::encode, MessageOpenDialogButtonEditor::decode, MessageOpenDialogButtonEditor::handle);
        INSTANCE.registerMessage(id++, MessageOpenDialogTextEditor.class, MessageOpenDialogTextEditor::encode, MessageOpenDialogTextEditor::decode, MessageOpenDialogTextEditor::handle);
        INSTANCE.registerMessage(id++, MessagePoseChange.class, MessagePoseChange::encode, MessagePoseChange::decode, MessagePoseChange::handle);
        INSTANCE.registerMessage(id++, MessagePositionChange.class, MessagePositionChange::encode, MessagePositionChange::decode, MessagePositionChange::handle);
        INSTANCE.registerMessage(id++, MessagePresetExport.class, MessagePresetExport::encode, MessagePresetExport::decode, MessagePresetExport::handle);
        INSTANCE.registerMessage(id++, MessagePresetExportWorld.class, MessagePresetExportWorld::encode, MessagePresetExportWorld::decode, MessagePresetExportWorld::handle);
        INSTANCE.registerMessage(id++, MessageProfessionChange.class, MessageProfessionChange::encode, MessageProfessionChange::decode, MessageProfessionChange::handle);
        INSTANCE.registerMessage(id++, MessageRemoveDialog.class, MessageRemoveDialog::encode, MessageRemoveDialog::decode, MessageRemoveDialog::handle);
        INSTANCE.registerMessage(id++, MessageRemoveDialogButton.class, MessageRemoveDialogButton::encode, MessageRemoveDialogButton::decode, MessageRemoveDialogButton::handle);
        INSTANCE.registerMessage(id++, MessageRemoveNPC.class, MessageRemoveNPC::encode, MessageRemoveNPC::decode, MessageRemoveNPC::handle);
        INSTANCE.registerMessage(id++, MessageRespawnNPC.class, MessageRespawnNPC::encode, MessageRespawnNPC::decode, MessageRespawnNPC::handle);
        INSTANCE.registerMessage(id++, MessageModelRotationChange.class, MessageModelRotationChange::encode, MessageModelRotationChange::decode, MessageModelRotationChange::handle);
        INSTANCE.registerMessage(id++, MessageSaveDialog.class, MessageSaveDialog::encode, MessageSaveDialog::decode, MessageSaveDialog::handle);
        INSTANCE.registerMessage(id++, MessageSaveDialogSet.class, MessageSaveDialogSet::encode, MessageSaveDialogSet::decode, MessageSaveDialogSet::handle);
        INSTANCE.registerMessage(id++, MessageSaveDialogButton.class, MessageSaveDialogButton::encode, MessageSaveDialogButton::decode, MessageSaveDialogButton::handle);
        INSTANCE.registerMessage(id++, MessageScaleChange.class, MessageScaleChange::encode, MessageScaleChange::decode, MessageScaleChange::handle);
        INSTANCE.registerMessage(id++, MessageSkinChange.class, MessageSkinChange::encode, MessageSkinChange::decode, MessageSkinChange::handle);
        INSTANCE.registerMessage(id++, MessageTradingTypeChange.class, MessageTradingTypeChange::encode, MessageTradingTypeChange::decode, MessageTradingTypeChange::handle);
    }

    public static <M> void sendToServer(M message) {
        try {
            INSTANCE.sendToServer(message);
        }
        catch (Exception e) {
            log.error("Failed to send {} to server, got error: {}", message, (Object)e.getMessage());
        }
    }

    public static <M> void sendToPlayer(M message, ServerPlayer serverPlayer) {
        try {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
        catch (Exception e) {
            log.error("Failed to send {} to player {}, got error: {}", message, (Object)serverPlayer.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

