/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkMessage {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final UUID EMPTY_UUID = new UUID(0L, 0L);
    protected static final Random RANDOM = new Random();
    protected final UUID uuid;

    public NetworkMessage(UUID uuid) {
        this.uuid = uuid;
    }

    public static boolean checkAccess(UUID uuid, ServerPlayer serverPlayer) {
        if (uuid == null || uuid.equals(EMPTY_UUID)) {
            log.error("Unable to get valid entity UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (serverPlayer == null) {
            log.error("Unable to get valid player for entity with UUID {}", (Object)uuid);
            return false;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (!LivingEntityManager.hasAccess(uuid, serverPlayer)) {
            log.error("User {} has no access to Easy NPC with uuid {}.", (Object)serverPlayer, (Object)uuid);
            return false;
        }
        return true;
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

