/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ServerNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public void triggerActionEvent(UUID var1, ActionEventType var2);

    public void triggerDialogButtonAction(UUID var1, UUID var2, UUID var3);

    public void changeSpawnerSettings(BlockPos var1, SpawnerSettingType var2, int var3);

    public void importPreset(UUID var1, PresetType var2, ResourceLocation var3);

    public void importPreset(UUID var1, PresetType var2, CompoundTag var3);

    default public void importCustomPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.CUSTOM, resourceLocation);
    }

    default public void importDataPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.DATA, resourceLocation);
    }

    default public void importDefaultPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.DEFAULT, resourceLocation);
    }

    default public void importLocalPreset(UUID uuid, CompoundTag compoundTag) {
        this.importPreset(uuid, PresetType.LOCAL, compoundTag);
    }

    default public void importWorldPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.WORLD, resourceLocation);
    }
}

