/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.cache.CacheManager;
import de.markusbordihn.easynpc.data.cache.CacheType;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class CacheDataSyncMessage
extends NetworkMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "cache_data_sync");
    private final CompoundTag data;
    private final CacheType cacheType;

    public CacheDataSyncMessage(UUID uuid, CacheType cacheType, CompoundTag data) {
        super(uuid);
        this.cacheType = cacheType;
        this.data = data;
    }

    public static CacheDataSyncMessage decode(FriendlyByteBuf buffer) {
        return new CacheDataSyncMessage(buffer.m_130259_(), (CacheType)buffer.m_130066_(CacheType.class), buffer.m_130260_());
    }

    public static FriendlyByteBuf encode(CacheDataSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.cacheType);
        buffer.m_130079_(message.data);
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        CacheDataSyncMessage.handle(CacheDataSyncMessage.decode(buffer), serverPlayer);
    }

    public static void handle(CacheDataSyncMessage message, ServerPlayer serverPlayer) {
        UUID uuid = message.getUUID();
        if (uuid == null || serverPlayer != null) {
            return;
        }
        CacheType cacheType = message.getCacheType();
        if (cacheType == null) {
            log.error("Unable to get valid cache type for {}", (Object)uuid);
            return;
        }
        CompoundTag data = message.getData();
        if (data == null || data.m_128456_()) {
            log.error("Unable to get valid data {} for {}", (Object)data, (Object)uuid);
            return;
        }
        switch (cacheType) {
            case ACTION_DATA_SET: {
                ActionEventSet actionEventSet = new ActionEventSet(data);
                log.info("Update action event set for {} with {}", (Object)uuid, (Object)actionEventSet);
                CacheManager.setActionDataSet(uuid, actionEventSet);
                break;
            }
            case DIALOG_DATA_SET: {
                DialogDataSet dialogDataSet = new DialogDataSet(data);
                log.info("Update dialog data set for {} with {}", (Object)uuid, (Object)dialogDataSet);
                CacheManager.setDialogDataSet(uuid, dialogDataSet);
                break;
            }
            case OBJECTIVE_DATA_SET: {
                ObjectiveDataSet objectiveDataSet = new ObjectiveDataSet(data);
                log.info("Update objective data set for {} with {}", (Object)uuid, (Object)objectiveDataSet);
                CacheManager.setObjectiveDataSet(uuid, objectiveDataSet);
                break;
            }
            case CUSTOM_PRESETS: {
                log.info("Update custom presets with {}", (Object)data);
                Set<ResourceLocation> customPresets = CompoundTagUtils.readResourceLocations(data.m_128437_("customPresets", 10));
                CacheManager.setCustomPresets(customPresets);
                break;
            }
            case WORLD_PRESETS: {
                log.info("Update world presets with {}", (Object)data);
                Set<ResourceLocation> worldPresets = CompoundTagUtils.readResourceLocations(data.m_128437_("worldPresets", 10));
                CacheManager.setWorldPresets(worldPresets);
                break;
            }
            case DEFAULT_PRESETS: {
                log.info("Update default presets with {}", (Object)data);
                Set<ResourceLocation> defaultPresets = CompoundTagUtils.readResourceLocations(data.m_128437_("defaultPresets", 10));
                CacheManager.setDefaultPresets(defaultPresets);
                break;
            }
            default: {
                log.error("Unknown cache type {} for {}", (Object)cacheType, (Object)uuid);
            }
        }
    }

    public FriendlyByteBuf encode() {
        return CacheDataSyncMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public CompoundTag getData() {
        return this.data;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }
}

