/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DialogButtonActionMessage
extends NetworkMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "dialog_button_action");
    protected final UUID dialogId;
    protected final UUID dialogButtonId;

    public DialogButtonActionMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        super(uuid);
        this.dialogId = dialogId;
        this.dialogButtonId = dialogButtonId;
    }

    public static DialogButtonActionMessage decode(FriendlyByteBuf buffer) {
        return new DialogButtonActionMessage(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130259_());
    }

    public static FriendlyByteBuf encode(DialogButtonActionMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.getDialogId());
        buffer.m_130077_(message.getDialogButtonId());
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        DialogButtonActionMessage.handle(DialogButtonActionMessage.decode(buffer), serverPlayer);
    }

    public static void handle(DialogButtonActionMessage message, ServerPlayer serverPlayer) {
        UUID uuid = message.getUUID();
        if (serverPlayer == null || uuid == null) {
            log.error("Unable to trigger dialog button action event with message {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        UUID dialogButtonId = message.getDialogButtonId();
        if (dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Dialog data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialogButton(dialogId, dialogButtonId)) {
            log.error("Unknown dialog button action {} request for dialog {} for UUID {} from {}", (Object)dialogButtonId, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogButtonData dialogButtonData = dialogData.getDialogButton(dialogId, dialogButtonId);
        if (dialogButtonData == null) {
            log.error("Unable to get valid dialog button data for UUID {} and dialog {} from {}", (Object)uuid, (Object)dialogId, (Object)serverPlayer);
            return;
        }
        Set<ActionDataEntry> actionDataEntryList = dialogButtonData.getActionData();
        if (actionDataEntryList == null || actionDataEntryList.isEmpty()) {
            log.error("Empty dialog button action {} request for UUID {} and dialog {} from {}", (Object)dialogButtonId, (Object)uuid, (Object)dialogId, (Object)serverPlayer);
            return;
        }
        ActionHandler<?> actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Action handler for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (actionDataEntryList.size() == 1) {
            log.debug("Trigger single dialog button action for {} from {} with action: {}", easyNPC, (Object)serverPlayer, (Object)actionDataEntryList.iterator().next());
            actionHandler.executeAction(actionDataEntryList.iterator().next(), serverPlayer);
        } else {
            log.debug("Trigger multiple dialog button actions for {} from {} with {} actions: {}", easyNPC, (Object)serverPlayer, (Object)actionDataEntryList.size(), actionDataEntryList);
            actionHandler.executeActions(actionDataEntryList, serverPlayer);
        }
    }

    public FriendlyByteBuf encode() {
        return DialogButtonActionMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public UUID getDialogButtonId() {
        return this.dialogButtonId;
    }
}

