/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageActionEventChange
extends NetworkMessage {
    protected final ActionDataEntry actionDataEntry;
    protected final ActionEventType actionEventType;

    public MessageActionEventChange(UUID uuid, ActionEventType actionEventType, String action) {
        this(uuid, actionEventType, new ActionDataEntry(ActionType.COMMAND, action));
    }

    public MessageActionEventChange(UUID uuid, ActionEventType actionEventType, ActionDataEntry actionDataEntry) {
        super(uuid);
        this.actionDataEntry = actionDataEntry;
        this.actionEventType = actionEventType;
    }

    public static MessageActionEventChange decode(FriendlyByteBuf buffer) {
        return new MessageActionEventChange(buffer.m_130259_(), (ActionEventType)buffer.m_130066_(ActionEventType.class), new ActionDataEntry(buffer.m_130260_()));
    }

    public static void encode(MessageActionEventChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getActionEventType());
        buffer.m_130079_(message.actionDataEntry.createTag());
    }

    public static void handle(MessageActionEventChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageActionEventChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageActionEventChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ActionEventType actionEventType = message.getActionEventType();
        if (actionEventType == null || actionEventType == ActionEventType.NONE) {
            log.error("Invalid action event type {} for {} from {}", (Object)actionEventType, (Object)message, (Object)serverPlayer);
            return;
        }
        ActionDataEntry actionDataEntry = message.getActionData();
        if (actionDataEntry == null || !actionDataEntry.isValid()) {
            log.error("Invalid action data {} for {} from {}", (Object)actionDataEntry, (Object)message, (Object)serverPlayer);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.m_20194_();
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.m_129944_(serverPlayer.m_36316_());
            log.debug("Set action owner permission level {} for {} from {}", (Object)permissionLevel, (Object)message, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        } else {
            log.warn("Unable to verify permission level from {} for {}", (Object)message, (Object)serverPlayer);
        }
        log.debug("Set action event {} with {} for {} from {} with owner permission level {}.", (Object)actionEventType, (Object)actionDataEntry, easyNPC, (Object)serverPlayer, (Object)permissionLevel);
        actionEventData.getActionEventSet().setActionEvent(actionEventType, actionDataEntry);
    }

    public ActionEventType getActionEventType() {
        return this.actionEventType;
    }

    public ActionDataEntry getActionData() {
        return this.actionDataEntry;
    }
}

