/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageAdvancedTrading
extends NetworkMessage {
    protected final int tradingOfferIndex;
    protected final float tradingValue;
    protected final TradingValueType tradingValueType;

    public MessageAdvancedTrading(UUID uuid, int tradingOfferIndex, TradingValueType tradingValueType, float tradingValue) {
        super(uuid);
        this.tradingOfferIndex = tradingOfferIndex;
        this.tradingValueType = tradingValueType;
        this.tradingValue = tradingValue;
    }

    public static MessageAdvancedTrading decode(FriendlyByteBuf buffer) {
        return new MessageAdvancedTrading(buffer.m_130259_(), buffer.readInt(), (TradingValueType)buffer.m_130066_(TradingValueType.class), buffer.readFloat());
    }

    public static void encode(MessageAdvancedTrading message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.writeInt(message.getTradingOfferIndex());
        buffer.m_130068_((Enum)message.getTradingValueType());
        buffer.writeFloat(message.getTradingValue());
    }

    public static void handle(MessageAdvancedTrading message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageAdvancedTrading.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageAdvancedTrading message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        int tradingOfferIndex = message.getTradingOfferIndex();
        if (tradingOfferIndex < 0) {
            log.error("Trading offer index {} is out of range (>= 0) for {}", (Object)tradingOfferIndex, (Object)serverPlayer);
            return;
        }
        TradingValueType tradingValueType = message.getTradingValueType();
        if (tradingValueType == null) {
            log.error("Trading value type {} is unknown for {}", (Object)tradingValueType, (Object)serverPlayer);
            return;
        }
        float tradingValue = message.getTradingValue();
        if ((double)tradingValue < 0.0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)Float.valueOf(tradingValue), (Object)tradingValueType, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (tradingValueType) {
            case RESETS_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)Float.valueOf(tradingValue), easyNPC, (Object)serverPlayer);
                tradingData.setTradingResetsEveryMin((int)tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set advanced trading max uses {}# for {} to {} by {}", (Object)tradingOfferIndex, easyNPC, (Object)Float.valueOf(tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingMaxUses(tradingOfferIndex, (int)tradingValue);
                break;
            }
            case XP: {
                log.debug("Set advanced trading xp {}# for {} to {} by {}", (Object)tradingOfferIndex, easyNPC, (Object)Float.valueOf(tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingXp(tradingOfferIndex, (int)tradingValue);
                break;
            }
            case PRICE_MULTIPLIER: {
                log.debug("Set advanced trading price multiplier {}# for {} to {} by {}", (Object)tradingOfferIndex, easyNPC, (Object)Float.valueOf(tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingPriceMultiplier(tradingOfferIndex, tradingValue);
                break;
            }
            case DEMAND: {
                log.debug("Set advanced trading demand {}# for {} to {} by {}", (Object)tradingOfferIndex, easyNPC, (Object)Float.valueOf(tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingDemand(tradingOfferIndex, (int)tradingValue);
                break;
            }
            default: {
                log.error("Trading value type {} with value {}# for {} is unknown for {}", (Object)tradingValueType, (Object)Float.valueOf(tradingValue), (Object)tradingOfferIndex, (Object)serverPlayer);
            }
        }
    }

    public int getTradingOfferIndex() {
        return this.tradingOfferIndex;
    }

    public TradingValueType getTradingValueType() {
        return this.tradingValueType;
    }

    public float getTradingValue() {
        return this.tradingValue;
    }

    public static enum TradingValueType {
        RESETS_EVERY_MIN,
        MAX_USES,
        XP,
        PRICE_MULTIPLIER,
        DEMAND;

    }
}

