/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageEntityAttributeChange
extends NetworkMessage {
    protected final EntityAttribute entityAttribute;
    protected final Boolean booleanValue;
    protected final Float floatValue;
    protected final Integer integerValue;
    protected final String stringValue;

    public MessageEntityAttributeChange(UUID uuid, EntityAttribute entityAttribute, Boolean booleanValue, Float floatValue, Integer integerValue, String stringValue) {
        super(uuid);
        this.entityAttribute = entityAttribute;
        this.booleanValue = booleanValue;
        this.floatValue = floatValue;
        this.integerValue = integerValue;
        this.stringValue = stringValue;
    }

    public MessageEntityAttributeChange(UUID uuid, EntityAttribute entityAttribute, Boolean value) {
        this(uuid, entityAttribute, value, Float.valueOf(0.0f), 0, "");
    }

    public MessageEntityAttributeChange(UUID uuid, EntityAttribute entityAttribute, Float value) {
        this(uuid, entityAttribute, false, value, 0, "");
    }

    public MessageEntityAttributeChange(UUID uuid, EntityAttribute entityAttribute, Integer value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), value, "");
    }

    public MessageEntityAttributeChange(UUID uuid, EntityAttribute entityAttribute, String value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), 0, value);
    }

    public static MessageEntityAttributeChange decode(FriendlyByteBuf buffer) {
        return new MessageEntityAttributeChange(buffer.m_130259_(), (EntityAttribute)buffer.m_130066_(EntityAttribute.class), buffer.readBoolean(), Float.valueOf(buffer.readFloat()), buffer.readInt(), buffer.m_130277_());
    }

    public static void encode(MessageEntityAttributeChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getAttributeType());
        buffer.writeBoolean(message.getBooleanValue().booleanValue());
        buffer.writeFloat(message.getFloatValue().floatValue());
        buffer.writeInt(message.getIntegerValue().intValue());
        buffer.m_130070_(message.getStringValue());
    }

    public static void handle(MessageEntityAttributeChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageEntityAttributeChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageEntityAttributeChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EntityAttribute entityAttribute = message.getAttributeType();
        if (entityAttribute == null) {
            log.error("Invalid entity attribute {} for {} from {}", (Object)entityAttribute, (Object)message, (Object)serverPlayer);
            return;
        }
        Boolean booleanValue = message.getBooleanValue();
        Float floatValue = message.getFloatValue();
        Integer integerValue = message.getIntegerValue();
        String stringValue = message.getStringValue();
        if (booleanValue == null && floatValue == null && integerValue == null && stringValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)entityAttribute, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to find entity {} for {} from {}", (Object)uuid, (Object)message, (Object)serverPlayer);
            return;
        }
        boolean successfullyChanged = false;
        if (entityAttribute == EntityAttribute.LIGHT_LEVEL) {
            successfullyChanged = AttributeHandler.setEntityAttribute(easyNPC, entityAttribute, integerValue);
        } else if (booleanValue != null) {
            successfullyChanged = AttributeHandler.setEntityAttribute(easyNPC, entityAttribute, booleanValue);
        }
        if (!successfullyChanged) {
            log.error("Unable to change entity attribute {} for {} from {}", (Object)entityAttribute, easyNPC, (Object)serverPlayer);
        }
    }

    public EntityAttribute getAttributeType() {
        return this.entityAttribute;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public Float getFloatValue() {
        return this.floatValue;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }
}

