/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageEntityBaseAttributeChange
extends NetworkMessage {
    protected final ResourceLocation attribute;
    protected final Double value;

    public MessageEntityBaseAttributeChange(UUID uuid, ResourceLocation attribute, Double value) {
        super(uuid);
        this.attribute = attribute;
        this.value = value;
    }

    public static MessageEntityBaseAttributeChange decode(FriendlyByteBuf buffer) {
        return new MessageEntityBaseAttributeChange(buffer.m_130259_(), buffer.m_130281_(), buffer.readDouble());
    }

    public static void encode(MessageEntityBaseAttributeChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130085_(message.attribute);
        buffer.writeDouble(message.value.doubleValue());
    }

    public static void handle(MessageEntityBaseAttributeChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageEntityBaseAttributeChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageEntityBaseAttributeChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ResourceLocation attribute = message.getAttribute();
        if (attribute == null) {
            log.error("Invalid base attribute for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        Double value = message.getValue();
        if (value == null) {
            log.error("Invalid value for base attribute {} for {} from {}", (Object)attribute, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to find entity {} for {} from {}", (Object)uuid, (Object)message, (Object)serverPlayer);
            return;
        }
        if (!AttributeHandler.setBaseAttribute(easyNPC, attribute, value)) {
            log.error("Unable to set base attribute {} for {} from {}", (Object)attribute, (Object)message, (Object)serverPlayer);
        }
    }

    public ResourceLocation getAttribute() {
        return this.attribute;
    }

    public Double getValue() {
        return this.value;
    }
}

