/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelLockRotationChange
extends NetworkMessage {
    protected final boolean lockRotation;

    public MessageModelLockRotationChange(UUID uuid, boolean lockRotation) {
        super(uuid);
        this.lockRotation = lockRotation;
    }

    public static MessageModelLockRotationChange decode(FriendlyByteBuf buffer) {
        return new MessageModelLockRotationChange(buffer.m_130259_(), buffer.readBoolean());
    }

    public static void encode(MessageModelLockRotationChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.writeBoolean(message.getLockRotation());
    }

    public static void handle(MessageModelLockRotationChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelLockRotationChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelLockRotationChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        boolean lockRotation = message.getLockRotation();
        log.debug("Reset and lock rotation {} for {} from {}", (Object)lockRotation, easyNPC, (Object)serverPlayer);
        modelData.setModelLockRotation(lockRotation);
    }

    public boolean getLockRotation() {
        return this.lockRotation;
    }
}

