/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelRotationChange
extends NetworkMessage {
    protected final ModelPart modelPart;
    protected final CustomRotation rotations;

    public MessageModelRotationChange(UUID uuid, ModelPart modelPart, float x, float y, float z) {
        this(uuid, modelPart, new CustomRotation(x, y, z));
    }

    public MessageModelRotationChange(UUID uuid, ModelPart modelPart, CustomRotation rotations) {
        super(uuid);
        this.modelPart = modelPart;
        this.rotations = rotations;
    }

    public static MessageModelRotationChange decode(FriendlyByteBuf buffer) {
        return new MessageModelRotationChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void encode(MessageModelRotationChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getModelPart());
        buffer.writeFloat(message.getX());
        buffer.writeFloat(message.getY());
        buffer.writeFloat(message.getZ());
    }

    public static void handle(MessageModelRotationChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelRotationChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelRotationChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        CustomRotation rotations = message.getRotations();
        if (rotations == null) {
            log.error("Invalid rotation for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} rotation to {}\u00b0 {}\u00b0 {}\u00b0 for {} from {}", (Object)modelPart, (Object)Float.valueOf(rotations.m_123156_()), (Object)Float.valueOf(rotations.m_123157_()), (Object)Float.valueOf(rotations.m_123158_()), easyNPC, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelHeadRotation(rotations);
                break;
            }
            case BODY: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelBodyRotation(rotations);
                break;
            }
            case ARMS: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelArmsRotation(rotations);
                break;
            }
            case LEFT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftArmRotation(rotations);
                break;
            }
            case RIGHT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightArmRotation(rotations);
                break;
            }
            case LEFT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftLegRotation(rotations);
                break;
            }
            case RIGHT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightLegRotation(rotations);
                break;
            }
            case ROOT: {
                modelData.setModelRootRotation(rotations);
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
        if (modelData.getModelPose() == ModelPose.CUSTOM && !modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
            easyNPC.getEntity().m_20124_(Pose.STANDING);
        }
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public CustomRotation getRotations() {
        return this.rotations;
    }

    public float getX() {
        return this.rotations.m_123156_();
    }

    public float getY() {
        return this.rotations.m_123157_();
    }

    public float getZ() {
        return this.rotations.m_123158_();
    }
}

