/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;

public class MessageModelVisibilityChange
extends NetworkMessage {
    protected final ModelPart modelPart;
    protected final boolean visible;

    public MessageModelVisibilityChange(UUID uuid, ModelPart modelPart, boolean visible) {
        super(uuid);
        this.modelPart = modelPart;
        this.visible = visible;
    }

    public static MessageModelVisibilityChange decode(FriendlyByteBuf buffer) {
        return new MessageModelVisibilityChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readBoolean());
    }

    public static void encode(MessageModelVisibilityChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getModelPart());
        buffer.writeBoolean(message.isVisible());
    }

    public static void handle(MessageModelVisibilityChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelVisibilityChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelVisibilityChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        boolean visible = message.isVisible();
        log.debug("Change {} visibility to {} for {} from {}", (Object)modelPart, (Object)visible, easyNPC, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelHeadVisible(visible);
                break;
            }
            case BODY: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelBodyVisible(visible);
                break;
            }
            case ARMS: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelArmsVisible(visible);
                break;
            }
            case LEFT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftArmVisible(visible);
                break;
            }
            case RIGHT_ARM: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightArmVisible(visible);
                break;
            }
            case LEFT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelLeftLegVisible(visible);
                break;
            }
            case RIGHT_LEG: {
                easyNPC.getEntity().m_20124_(Pose.STANDING);
                modelData.setModelPose(ModelPose.CUSTOM);
                modelData.setModelRightLegVisible(visible);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
        if (modelData.getModelPose() == ModelPose.CUSTOM && !modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
            easyNPC.getEntity().m_20124_(Pose.STANDING);
        }
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

