/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;

public class MessagePoseChange
extends NetworkMessage {
    protected final Pose pose;

    public MessagePoseChange(UUID uuid, Pose pose) {
        super(uuid);
        this.pose = pose;
    }

    public static MessagePoseChange decode(FriendlyByteBuf buffer) {
        return new MessagePoseChange(buffer.m_130259_(), (Pose)buffer.m_130066_(Pose.class));
    }

    public static void encode(MessagePoseChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getPose());
    }

    public static void handle(MessagePoseChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePoseChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePoseChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Pose pose = message.getPose();
        if (pose == null) {
            log.error("Invalid pose {} for {} from {}", (Object)pose, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Missing model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change pose {} for {} from {}", (Object)pose, easyNPC, (Object)serverPlayer);
        modelData.setModelPose(ModelPose.DEFAULT);
        easyNPC.getEntity().m_20124_(pose);
    }

    public Pose getPose() {
        return this.pose;
    }
}

