/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class MessagePositionChange
extends NetworkMessage {
    protected final Vec3 pos;

    public MessagePositionChange(UUID uuid, float x, float y, float z) {
        this(uuid, new Vec3((double)x, (double)y, (double)z));
    }

    public MessagePositionChange(UUID uuid, Vec3 pos) {
        super(uuid);
        this.pos = pos;
    }

    public static MessagePositionChange decode(FriendlyByteBuf buffer) {
        return new MessagePositionChange(buffer.m_130259_(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void encode(MessagePositionChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.writeFloat(message.getX());
        buffer.writeFloat(message.getY());
        buffer.writeFloat(message.getZ());
    }

    public static void handle(MessagePositionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePositionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePositionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Vec3 pos = message.getPos();
        if (pos == null) {
            log.error("Invalid pos {} for {} from {}", (Object)pos, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change pos {} for {} from {}", (Object)pos, easyNPC, (Object)serverPlayer);
        easyNPC.getEntity().m_146884_(pos);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public float getX() {
        return (float)this.pos.f_82479_;
    }

    public float getY() {
        return (float)this.pos.f_82480_;
    }

    public float getZ() {
        return (float)this.pos.f_82481_;
    }
}

