/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessagePresetExport
extends NetworkMessage {
    protected final String name;

    public MessagePresetExport(UUID uuid, String name) {
        super(uuid);
        this.name = name;
    }

    public static MessagePresetExport decode(FriendlyByteBuf buffer) {
        return new MessagePresetExport(buffer.m_130259_(), buffer.m_130277_());
    }

    public static void encode(MessagePresetExport message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getName());
    }

    public static void handle(MessagePresetExport message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetExport.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetExport message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Object name = message.getName();
        if (name == null || ((String)name).isEmpty()) {
            log.warn("Export preset name is empty for {}", (Object)uuid);
            return;
        }
        if (!((String)name).endsWith(".npc.nbt")) {
            name = (String)name + ".npc.nbt";
        }
        NetworkMessageHandlerManager.getClientHandler().exportClientPreset(uuid, (String)name, serverPlayer);
    }

    public String getName() {
        return this.name;
    }
}

