/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessagePresetExportWorld
extends NetworkMessage {
    protected final String name;

    public MessagePresetExportWorld(UUID uuid, String name) {
        super(uuid);
        this.name = name;
    }

    public static MessagePresetExportWorld decode(FriendlyByteBuf buffer) {
        return new MessagePresetExportWorld(buffer.m_130259_(), buffer.m_130277_());
    }

    public static void encode(MessagePresetExportWorld message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getName());
    }

    public static void handle(MessagePresetExportWorld message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetExportWorld.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetExportWorld message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.warn("Export preset name is empty for {}", (Object)uuid);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("Export preset skin data is empty for {}", (Object)uuid);
            return;
        }
        SkinModel skinModel = skinData.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", (Object)uuid);
            return;
        }
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.exportPresetData();
        if (compoundTag == null || compoundTag.m_128456_()) {
            log.warn("Export preset data is empty for {}", (Object)uuid);
            return;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinModel, name);
        if (presetFile == null) {
            log.error("Failed to get preset file for {} with name {}", (Object)skinModel, (Object)name);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)compoundTag, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }

    public String getName() {
        return this.name;
    }
}

