/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageRemoveDialogButton
extends NetworkMessage {
    protected final UUID dialogId;
    protected final UUID dialogButtonId;

    public MessageRemoveDialogButton(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        super(uuid);
        this.dialogId = dialogId;
        this.dialogButtonId = dialogButtonId;
    }

    public static MessageRemoveDialogButton decode(FriendlyByteBuf buffer) {
        return new MessageRemoveDialogButton(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130259_());
    }

    public static void encode(MessageRemoveDialogButton message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.getDialogId());
        buffer.m_130077_(message.getDialogButtonId());
    }

    public static void handle(MessageRemoveDialogButton message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRemoveDialogButton.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRemoveDialogButton message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to remove dialog with message {} from {}", (Object)message, (Object)context);
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)message, (Object)context);
            return;
        }
        UUID dialogButtonId = message.getDialogButtonId();
        if (dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)message, (Object)context);
            return;
        }
        if (!dialogData.hasDialog(dialogId) || !dialogData.hasDialogButton(dialogId, dialogButtonId)) {
            log.error("Unknown delete dialog request for dialog button {} for dialog {} for {} from {}", (Object)dialogButtonId, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            return;
        }
        if (dialogData.removeDialogButton(dialogId, dialogButtonId)) {
            log.info("Removed dialog button {} from dialog {} for {} from {}", (Object)dialogButtonId, (Object)dialogId, easyNPC, (Object)serverPlayer);
        } else {
            log.warn("Unable to remove dialog button {} from dialog {} for {} from {}", (Object)dialogButtonId, (Object)dialogId, easyNPC, (Object)serverPlayer);
        }
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public UUID getDialogButtonId() {
        return this.dialogButtonId;
    }
}

