/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageRemoveNPC
extends NetworkMessage {
    public MessageRemoveNPC(UUID uuid) {
        super(uuid);
    }

    public static MessageRemoveNPC decode(FriendlyByteBuf buffer) {
        return new MessageRemoveNPC(buffer.m_130259_());
    }

    public static void encode(MessageRemoveNPC message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
    }

    public static void handle(MessageRemoveNPC message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRemoveNPC.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRemoveNPC message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPCEntity = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.info("Removing Easy NPC {} requested by {}", easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.getEntity().m_146870_();
    }
}

