/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class MessageRespawnNPC
extends NetworkMessage {
    public MessageRespawnNPC(UUID uuid) {
        super(uuid);
    }

    public static MessageRespawnNPC decode(FriendlyByteBuf buffer) {
        return new MessageRespawnNPC(buffer.m_130259_());
    }

    public static void encode(MessageRespawnNPC message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
    }

    public static void handle(MessageRespawnNPC message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRespawnNPC.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRespawnNPC message, NetworkEvent.Context context) {
        ServerLevel serverLevel;
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        CompoundTag compoundTag = easyNPC.getEntity().m_20240_(new CompoundTag());
        EntityType entityType = easyNPC.getEntity().m_6095_();
        Entity entity = entityType.m_20615_((Level)(serverLevel = serverPlayer.m_284548_()));
        if (entity == null) {
            log.error("Unable to create new entity with type {} for {}", (Object)entityType, (Object)serverPlayer);
            return;
        }
        entity.m_20258_(compoundTag);
        easyNPC.getEntity().m_146870_();
        log.info("Respawn Easy NPC {} with {} requested by {}", easyNPC, (Object)entityType, (Object)serverPlayer);
        serverLevel.m_7967_(entity);
    }
}

