/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageSaveDialog
extends NetworkMessage {
    protected final UUID dialogId;
    protected final DialogDataEntry dialogDataEntry;

    public MessageSaveDialog(UUID uuid, UUID dialogId, DialogDataEntry dialogDataEntry) {
        super(uuid);
        this.dialogId = dialogId;
        this.dialogDataEntry = dialogDataEntry;
    }

    public static MessageSaveDialog decode(FriendlyByteBuf buffer) {
        return new MessageSaveDialog(buffer.m_130259_(), buffer.m_130259_(), new DialogDataEntry(buffer.m_130260_()));
    }

    public static void encode(MessageSaveDialog message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.getDialogId());
        buffer.m_130079_(message.getDialogDataEntry().createTag());
    }

    public static void handle(MessageSaveDialog message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSaveDialog.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSaveDialog message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to save dialog with message {} from {}", (Object)message, (Object)context);
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)message, (Object)context);
            return;
        }
        DialogDataEntry dialogDataEntry = message.getDialogDataEntry();
        if (dialogDataEntry == null) {
            log.error("Invalid dialog data for {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)message, (Object)context);
            return;
        }
        if (!dialogData.hasDialog(dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            return;
        }
        log.debug("Saving dialog data {} for dialog {} for {} from {}", (Object)dialogDataEntry, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
        dialogData.setDialog(dialogId, dialogDataEntry);
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public DialogDataEntry getDialogDataEntry() {
        return this.dialogDataEntry;
    }
}

