/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageSaveDialogButton
extends NetworkMessage {
    protected final UUID dialogId;
    protected final UUID dialogButtonId;
    protected final DialogButtonData dialogButtonData;

    public MessageSaveDialogButton(UUID uuid, UUID dialogId, UUID dialogButtonId, DialogButtonData dialogButtonData) {
        super(uuid);
        this.dialogId = dialogId;
        this.dialogButtonId = dialogButtonId;
        this.dialogButtonData = dialogButtonData;
    }

    public static MessageSaveDialogButton decode(FriendlyByteBuf buffer) {
        return new MessageSaveDialogButton(buffer.m_130259_(), buffer.m_130259_(), buffer.m_130259_(), new DialogButtonData(buffer.m_130260_()));
    }

    public static void encode(MessageSaveDialogButton message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130077_(message.getDialogId());
        buffer.m_130077_(message.getDialogButtonId());
        buffer.m_130079_(message.getDialogButtonData().createTag());
    }

    public static void handle(MessageSaveDialogButton message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSaveDialogButton.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSaveDialogButton message, NetworkEvent.Context context) {
        int permissionLevel;
        MinecraftServer minecraftServer;
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        UUID dialogId = message.getDialogId();
        if (dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)message, (Object)context);
            return;
        }
        DialogButtonData dialogButtonData = message.getDialogButtonData();
        if (dialogButtonData == null) {
            log.error("Invalid dialog button data for {} from {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)message, (Object)context);
            return;
        }
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Invalid action data for {} from {}", (Object)message, (Object)context);
            return;
        }
        if (!dialogData.hasDialog(dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            return;
        }
        UUID dialogButtonId = message.getDialogButtonId();
        if (dialogButtonId != null && !dialogData.hasDialogButton(dialogId, dialogButtonId)) {
            log.error("Invalid dialog button {} for {} from {}", (Object)dialogButtonId, (Object)message, (Object)context);
            return;
        }
        int currentPermissionLevel = actionEventData.getActionPermissionLevel();
        if (currentPermissionLevel == 0 && (minecraftServer = serverPlayer.m_20194_()) != null && (permissionLevel = minecraftServer.m_129944_(serverPlayer.m_36316_())) > currentPermissionLevel) {
            log.debug("Update owner permission level from {} to {} for {} from {}", (Object)currentPermissionLevel, (Object)permissionLevel, easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        }
        if (dialogButtonId == null) {
            log.info("Add new dialog button {} for dialog {} for {} from {}", (Object)dialogButtonData, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(dialogId).setButton(dialogButtonData);
        } else {
            log.info("Edit existing dialog button {} for dialog {} for {} from {}", (Object)dialogButtonData, (Object)dialogId, (Object)uuid, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(dialogId).setButton(dialogButtonId, dialogButtonData);
        }
    }

    public UUID getDialogId() {
        return this.dialogId;
    }

    public UUID getDialogButtonId() {
        return this.dialogButtonId;
    }

    public DialogButtonData getDialogButtonData() {
        return this.dialogButtonData;
    }
}

