/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageSkinChange
extends NetworkMessage {
    protected final String skinName;
    protected final String skinURL;
    protected final UUID skinUUID;
    protected final SkinType skinType;
    protected final String skinVariant;

    public MessageSkinChange(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariant) {
        super(uuid);
        this.skinName = skinName;
        this.skinURL = skinURL;
        this.skinUUID = skinUUID;
        this.skinType = skinType;
        this.skinVariant = skinVariant;
    }

    public static MessageSkinChange decode(FriendlyByteBuf buffer) {
        return new MessageSkinChange(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130259_(), (SkinType)buffer.m_130066_(SkinType.class), buffer.m_130277_());
    }

    public static void encode(MessageSkinChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getSkinName());
        buffer.m_130070_(message.getSkinURL());
        buffer.m_130077_(message.getSkinUUID());
        buffer.m_130068_((Enum)message.getSkinType());
        buffer.m_130070_(message.getSkinVariant());
    }

    public static void handle(MessageSkinChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSkinChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSkinChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String skinName = message.getSkinName();
        if (skinName == null) {
            log.error("Invalid skin {} for {} from {}", (Object)skinName, (Object)message, (Object)serverPlayer);
            return;
        }
        SkinType skinType = message.getSkinType();
        if (skinType == null) {
            log.error("Invalid skin type {} for {} from {}", (Object)skinType, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.error("Skin data for {} is not available for {}", easyNPC, (Object)serverPlayer);
            return;
        }
        String skinVariant = message.getSkinVariant();
        String skinURL = message.getSkinURL();
        UUID skinUUID = message.getSkinUUID();
        switch (skinType) {
            case NONE: {
                SkinHandler.setNoneSkin(easyNPC);
                break;
            }
            case CUSTOM: {
                SkinHandler.setCustomSkin(easyNPC, skinUUID);
                break;
            }
            case DEFAULT: {
                SkinHandler.setDefaultSkin(easyNPC, skinVariant);
                break;
            }
            case PLAYER_SKIN: {
                UUID userUUID;
                UUID uUID = userUUID = skinUUID != null && !Constants.BLANK_UUID.equals(skinUUID) ? skinUUID : PlayersUtils.getUserUUID(serverPlayer.m_20194_(), skinName);
                if (userUUID != null && !skinName.equals(userUUID.toString())) {
                    log.debug("Converted user {} to UUID {} ...", (Object)skinName, (Object)userUUID);
                }
                SkinHandler.setPlayerSkin(easyNPC, skinName, userUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                SkinHandler.setRemoteSkin(easyNPC, skinURL);
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)skinName, (Object)skinUUID, (Object)skinURL, (Object)skinType, easyNPC, (Object)serverPlayer);
                skinData.setSkinType(skinType);
                skinData.setSkinName(skinName);
            }
        }
    }

    public String getSkinName() {
        return this.skinName;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public UUID getSkinUUID() {
        return this.skinUUID;
    }

    public SkinType getSkinType() {
        return this.skinType;
    }

    public String getSkinVariant() {
        return this.skinVariant;
    }
}

