/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.NetworkMessage;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PresetExportClientMessage
extends NetworkMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "preset_export_client");
    protected final String name;
    protected final SkinModel skinModel;
    protected final String fileName;
    protected final CompoundTag data;

    public PresetExportClientMessage(UUID uuid, String name, SkinModel skinModel, String fileName, CompoundTag data) {
        super(uuid);
        this.name = name;
        this.skinModel = skinModel;
        this.fileName = fileName;
        this.data = data;
    }

    public static PresetExportClientMessage decode(FriendlyByteBuf buffer) {
        return new PresetExportClientMessage(buffer.m_130259_(), buffer.m_130277_(), (SkinModel)buffer.m_130066_(SkinModel.class), buffer.m_130277_(), buffer.m_130260_());
    }

    public static FriendlyByteBuf encode(PresetExportClientMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getName());
        buffer.m_130068_((Enum)message.getSkinModel());
        buffer.m_130070_(message.getFileName());
        buffer.m_130079_(message.getData());
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        PresetExportClientMessage.handle(PresetExportClientMessage.decode(buffer), serverPlayer);
    }

    public static void handle(PresetExportClientMessage message, ServerPlayer serverPlayer) {
        UUID uuid = message.getUUID();
        if (uuid == null || uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)uuid, (Object)message);
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.error("Invalid name {} for {}", (Object)name, (Object)message);
            return;
        }
        SkinModel skinModel = message.getSkinModel();
        if (skinModel == null) {
            log.error("Invalid skin model {} for {}", (Object)skinModel, (Object)message);
            return;
        }
        CompoundTag data = message.getData();
        if (data == null) {
            log.error("Invalid data {} for {}", (Object)data, (Object)message);
            return;
        }
        String fileName = message.getFileName();
        if (fileName == null || fileName.isEmpty()) {
            log.warn("Export preset file name is empty for {}", (Object)uuid);
            return;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile(skinModel, fileName);
        if (presetFile == null) {
            log.error("Failed to get preset file for {}", (Object)message);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)data, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }

    public FriendlyByteBuf encode() {
        return PresetExportClientMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public String getName() {
        return this.name;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public CompoundTag getData() {
        return this.data;
    }
}

