/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.NetworkMessage;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class TriggerActionEventMessage
extends NetworkMessage {
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "trigger_action_event");
    protected final ActionEventType actionEventType;

    public TriggerActionEventMessage(UUID uuid, ActionEventType actionEventType) {
        super(uuid);
        this.actionEventType = actionEventType;
    }

    public static TriggerActionEventMessage decode(FriendlyByteBuf buffer) {
        return new TriggerActionEventMessage(buffer.m_130259_(), (ActionEventType)buffer.m_130066_(ActionEventType.class));
    }

    public static FriendlyByteBuf encode(TriggerActionEventMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getActionType());
        return buffer;
    }

    public static void handle(FriendlyByteBuf buffer, ServerPlayer serverPlayer) {
        TriggerActionEventMessage.handle(TriggerActionEventMessage.decode(buffer), serverPlayer);
    }

    public static void handle(TriggerActionEventMessage message, ServerPlayer serverPlayer) {
        UUID uuid = message.getUUID();
        if (serverPlayer == null || uuid == null) {
            log.error("Unable to trigger action event with message {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        ActionEventType actionEventType = message.getActionType();
        if (actionEventType == null || actionEventType == ActionEventType.NONE) {
            log.error("Invalid action event type {} for {} from {}", (Object)actionEventType, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Unable to get valid action event data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ActionHandler<?> actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Unable to get valid action handler for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        Set<ActionDataEntry> actionDataEntryList = actionEventData.getActionEventSet().getActionEvents(actionEventType);
        if (actionDataEntryList == null || actionDataEntryList.isEmpty()) {
            log.error("Unknown trigger action event {} request for UUID {} from {}", (Object)actionEventType, (Object)uuid, (Object)serverPlayer);
            return;
        }
        if (actionDataEntryList.size() > 1) {
            log.debug("Trigger multiple actions events for {} from {} with {} actions ...", easyNPC, (Object)serverPlayer, (Object)actionDataEntryList.size());
        }
        for (ActionDataEntry actionDataEntry : actionDataEntryList) {
            if (actionDataEntry == null) continue;
            log.debug("Trigger action event {} for {} from {} with permission level {} ...", (Object)actionDataEntry, easyNPC, (Object)serverPlayer, (Object)actionDataEntry.getPermissionLevel());
            actionHandler.executeAction(actionDataEntry, serverPlayer);
        }
    }

    public FriendlyByteBuf encode() {
        return TriggerActionEventMessage.encode(this, new FriendlyByteBuf(Unpooled.buffer()));
    }

    public ActionEventType getActionType() {
        return this.actionEventType;
    }
}

