/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBufferSorter;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobCollector;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderSortTask;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.lists.VisibleChunkCollector;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.iterator.ByteIterator;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.embeddedt.embeddium.api.ChunkMeshEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSectionManager {
    private final ChunkBuilder builder;
    private final Thread renderThread = Thread.currentThread();
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<ChunkBuildOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ChunkRenderer chunkRenderer;
    private final ClientLevel world;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final OcclusionCuller occlusionCuller;
    private final int renderDistance;
    private final ChunkVertexType vertexType;
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists;
    private int lastUpdatedFrame;
    private boolean needsUpdate;
    @Nullable
    private BlockPos lastCameraPosition;
    private Vec3 cameraPosition = Vec3.f_82478_;
    private final boolean translucencySorting;
    private final int translucencyBlockRenderDistance;
    private float lastCameraTranslucentX;
    private float lastCameraTranslucentY;
    private float lastCameraTranslucentZ;
    private static final float NEARBY_REBUILD_DISTANCE = Mth.m_14207_((float)16.0f);

    public RenderSectionManager(ClientLevel world, int renderDistance, CommandList commandList) {
        ChunkVertexType vertexType = SodiumClientMod.canUseVanillaVertices() ? ChunkMeshFormats.VANILLA_LIKE : ChunkMeshFormats.COMPACT;
        this.chunkRenderer = new DefaultChunkRenderer(RenderDevice.INSTANCE, vertexType);
        this.vertexType = vertexType;
        this.world = world;
        this.builder = new ChunkBuilder(world, vertexType);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((Level)this.world);
        this.renderLists = SortedRenderLists.empty();
        this.occlusionCuller = new OcclusionCuller((Long2ReferenceMap<RenderSection>)Long2ReferenceMaps.unmodifiable(this.sectionByPosition), (Level)this.world);
        this.rebuildLists = new EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>>(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildLists.put(type, new ArrayDeque());
        }
        this.translucencySorting = SodiumClientMod.options().performance.useTranslucentFaceSorting;
        this.translucencyBlockRenderDistance = Math.min(9216, (renderDistance << 4) * (renderDistance << 4));
    }

    public void update(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.lastCameraPosition = camera.m_90588_();
        this.cameraPosition = camera.m_90583_();
        this.scheduleTranslucencyUpdates();
        this.createTerrainRenderList(camera, viewport, frame, spectator);
        this.needsUpdate = false;
        this.lastUpdatedFrame = frame;
    }

    private void scheduleTranslucencyUpdates() {
        if (!this.translucencySorting || this.lastCameraPosition == null) {
            return;
        }
        float dx = this.lastCameraTranslucentX - (float)this.cameraPosition.f_82479_;
        float dy = this.lastCameraTranslucentY - (float)this.cameraPosition.f_82480_;
        float dz = this.lastCameraTranslucentZ - (float)this.cameraPosition.f_82481_;
        if ((double)(dx * dx + dy * dy + dz * dz) > 1.0) {
            this.lastCameraTranslucentX = (float)this.cameraPosition.f_82479_;
            this.lastCameraTranslucentY = (float)this.cameraPosition.f_82480_;
            this.lastCameraTranslucentZ = (float)this.cameraPosition.f_82481_;
            for (Long2ReferenceMap.Entry entry : Long2ReferenceMaps.fastIterable(this.sectionByPosition)) {
                ChunkUpdateType update;
                boolean hasTranslucentData;
                RenderSection section = (RenderSection)entry.getValue();
                if (!section.isBuilt() || !(hasTranslucentData = (section.getFlags() & 0x10) != 0 && section.getTranslucencyData() != null) || !(section.getSquaredDistance(this.lastCameraPosition) < (float)this.translucencyBlockRenderDistance) || (update = ChunkUpdateType.getPromotionUpdateType(section.getPendingUpdate(), RenderSectionManager.allowImportantRebuilds() && this.shouldPrioritizeRebuild(section) ? ChunkUpdateType.IMPORTANT_SORT : ChunkUpdateType.SORT)) == null) continue;
                section.setPendingUpdate(update);
            }
        }
    }

    private void createTerrainRenderList(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.resetRenderLists();
        float searchDistance = this.getSearchDistance();
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        VisibleChunkCollector visitor = new VisibleChunkCollector(frame);
        this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
        this.renderLists = visitor.createRenderLists();
        this.rebuildLists = visitor.getRebuildLists();
    }

    private float getSearchDistance() {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(Camera camera, boolean spectator) {
        BlockPos origin = camera.m_90588_();
        boolean useOcclusionCulling = spectator && this.world.m_8055_(origin).m_60804_((BlockGetter)this.world, origin) ? false : Minecraft.m_91087_().f_90980_;
        return useOcclusionCulling;
    }

    private void resetRenderLists() {
        this.renderLists = SortedRenderLists.empty();
        for (ArrayDeque<RenderSection> list : this.rebuildLists.values()) {
            list.clear();
        }
    }

    public void onSectionAdded(int x, int y, int z) {
        boolean isEmpty;
        long key = SectionPos.m_123209_((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        LevelChunk chunk = this.world.m_6325_(x, z);
        LevelChunkSection section = chunk.m_7103_()[this.world.m_151566_(y)];
        boolean bl = isEmpty = (section == null || section.m_188008_()) && ChunkMeshEvent.post((Level)this.world, SectionPos.m_123173_((int)x, (int)y, (int)z)).isEmpty();
        if (isEmpty) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(renderSection);
        this.needsUpdate = true;
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderSection section = (RenderSection)this.sectionByPosition.remove(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (section == null) {
            return;
        }
        RenderRegion region = section.getRegion();
        if (region != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.needsUpdate = true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.renderLists, pass, new CameraTransform(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                TextureAtlasSprite[] sprites;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteUtil.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.lastUpdatedFrame;
    }

    public void updateChunks(boolean updateImmediately) {
        this.sectionCache.cleanup();
        this.regions.update();
        ChunkJobCollector blockingRebuilds = new ChunkJobCollector(Integer.MAX_VALUE, this.buildResults::add);
        ChunkJobCollector deferredRebuilds = new ChunkJobCollector(this.builder.getSchedulingBudget(), this.buildResults::add);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_SORT);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.REBUILD);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.INITIAL_BUILD);
        ChunkJobCollector deferredSorts = new ChunkJobCollector(Math.max(1, this.builder.getSchedulingBudget()), this.buildResults::add);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredSorts, ChunkUpdateType.SORT);
        blockingRebuilds.awaitCompletion(this.builder);
    }

    public void uploadChunks() {
        ArrayList<ChunkBuildOutput> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.processChunkBuildResults(results);
        for (ChunkBuildOutput result : results) {
            result.delete();
        }
        this.needsUpdate = true;
    }

    private void processChunkBuildResults(ArrayList<ChunkBuildOutput> results) {
        List<ChunkBuildOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadMeshes(RenderDevice.INSTANCE.createCommandList(), filtered);
        for (ChunkBuildOutput result : filtered) {
            CancellationToken job;
            if (result.info != null) {
                this.updateSectionInfo(result.render, result.info);
                if (this.translucencySorting) {
                    this.updateTranslucencyInfo(result.render, result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT));
                }
            }
            if ((job = result.render.getBuildCancellationToken()) != null && result.buildTime >= result.render.getLastSubmittedFrame()) {
                result.render.setBuildCancellationToken(null);
            }
            result.render.setLastBuiltFrame(result.buildTime);
        }
    }

    private void updateTranslucencyInfo(RenderSection render, BuiltSectionMeshParts translucencyMesh) {
        if (translucencyMesh == null) {
            return;
        }
        ByteBuffer vertexBuffer = translucencyMesh.getVertexData().getDirectBuffer();
        ByteBuffer heapBuffer = ByteBuffer.allocate(vertexBuffer.capacity()).order(ByteOrder.nativeOrder());
        heapBuffer.put(vertexBuffer);
        heapBuffer.flip();
        render.setTranslucencyData(new ChunkBufferSorter.SortBuffer(heapBuffer, this.chunkRenderer.getVertexType(), translucencyMesh.getVertexRanges()));
    }

    private void updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            this.sectionsWithGlobalEntities.remove((Object)render);
        } else {
            this.sectionsWithGlobalEntities.add((Object)render);
        }
    }

    private static List<ChunkBuildOutput> filterChunkBuildResults(ArrayList<ChunkBuildOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (ChunkBuildOutput output : outputs) {
            RenderSection render;
            ChunkBuildOutput previous;
            if (output.render.isDisposed() || output.render.getLastBuiltFrame() > output.buildTime || (previous = (ChunkBuildOutput)map.get((Object)(render = output.render))) != null && previous.buildTime >= output.buildTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<ChunkBuildOutput>((Collection<ChunkBuildOutput>)map.values());
    }

    private ArrayList<ChunkBuildOutput> collectChunkBuildResults() {
        ChunkJobResult<ChunkBuildOutput> result;
        ArrayList<ChunkBuildOutput> results = new ArrayList<ChunkBuildOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
        }
        return results;
    }

    private void submitRebuildTasks(ChunkJobCollector collector, ChunkUpdateType type) {
        ArrayDeque<RenderSection> queue = this.rebuildLists.get((Object)type);
        while (!queue.isEmpty() && collector.canOffer()) {
            ChunkBuilderTask task;
            RenderSection section = queue.remove();
            if (section.isDisposed() || section.getPendingUpdate() != type) continue;
            int frame = this.lastUpdatedFrame;
            ChunkBuilderTask chunkBuilderTask = task = type.isSort() ? this.createSortTask(section, frame) : this.createRebuildTask(section, frame);
            if (task == null && type.isSort()) {
                section.setPendingUpdate(null);
                continue;
            }
            if (task != null) {
                ChunkJobTyped job = this.builder.scheduleTask(task, type.isImportant(), collector::onJobFinished);
                collector.addSubmittedJob(job);
                section.setBuildCancellationToken(job);
                if (!type.isSort()) {
                    section.setTranslucencyData(null);
                }
            } else {
                ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, BuiltSectionInfo.EMPTY, Collections.emptyMap(), frame));
                this.buildResults.add(result);
                section.setBuildCancellationToken(null);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
        }
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame) {
        ChunkRenderContext context = WorldSlice.prepare((Level)this.world, render.getPosition(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkBuilderMeshingTask(render, context, frame).withCameraPosition(this.cameraPosition);
    }

    public ChunkBuilderSortTask createSortTask(RenderSection render, int frame) {
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        ChunkBufferSorter.SortBuffer sortBuffer = render.getTranslucencyData();
        if (sortBuffer == null) {
            return null;
        }
        meshes.put(DefaultTerrainRenderPasses.TRANSLUCENT, sortBuffer.duplicate());
        return new ChunkBuilderSortTask(render, (float)this.cameraPosition.f_82479_, (float)this.cameraPosition.f_82480_, (float)this.cameraPosition.f_82481_, frame, (Map<TerrainRenderPass, ChunkBufferSorter.SortBuffer>)meshes);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (ChunkBuildOutput result : this.collectChunkBuildResults()) {
            result.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    private void scheduleRebuildOffThread(int x, int y, int z, boolean important) {
        Minecraft.m_91087_().m_18707_(() -> this.scheduleRebuild(x, y, z, important));
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        if (Thread.currentThread() != this.renderThread) {
            this.scheduleRebuildOffThread(x, y, z, important);
            return;
        }
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (section != null) {
            ChunkUpdateType pendingUpdate = RenderSectionManager.allowImportantRebuilds() && (important || this.shouldPrioritizeRebuild(section)) ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            pendingUpdate = ChunkUpdateType.getPromotionUpdateType(section.getPendingUpdate(), pendingUpdate);
            if (pendingUpdate != null) {
                section.setPendingUpdate(pendingUpdate);
                this.needsUpdate = true;
            }
        }
    }

    private boolean shouldPrioritizeRebuild(RenderSection section) {
        return this.lastCameraPosition != null && section.getSquaredDistance(this.lastCameraPosition) < NEARBY_REBUILD_DISTANCE;
    }

    private static boolean allowImportantRebuilds() {
        return !SodiumClientMod.options().performance.alwaysDeferChunkUpdates;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        if (!Mth.m_14033_((float)color[3], (float)1.0f)) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena buffer = resources.getGeometryArena();
            deviceUsed += (long)buffer.getDeviceUsedMemory();
            deviceAllocated += (long)buffer.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Geometry Pool: %d/%d MiB (%d buffers)", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated), count));
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk Builder: Permits=%02d | Busy=%02d | Total=%02d", this.builder.getScheduledJobCount(), this.builder.getBusyThreadCount(), this.builder.getTotalThreadCount()));
        list.add(String.format("Chunk Queues: U=%02d (P0=%03d | P1=%03d | P2=%03d)", this.buildResults.size(), this.rebuildLists.get((Object)ChunkUpdateType.IMPORTANT_REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.INITIAL_BUILD).size()));
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }

    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

