/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.entity.fast_render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.model.ModelCuboidAccessor;
import me.jellysquid.mods.sodium.client.render.immediate.model.EntityRenderer;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelPartData;
import me.jellysquid.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.client.model.geom.ModelPart;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelPartMixin
implements ModelPartData {
    @Shadow
    public float f_104200_;
    @Shadow
    public float f_104201_;
    @Shadow
    public float f_104202_;
    @Shadow
    public float f_233553_;
    @Shadow
    public float f_233554_;
    @Shadow
    public float f_233555_;
    @Shadow
    public float f_104204_;
    @Shadow
    public float f_104203_;
    @Shadow
    public float f_104205_;
    @Shadow
    public boolean f_104207_;
    @Shadow
    public boolean f_233556_;
    @Mutable
    @Shadow
    @Final
    private List<ModelPart.Cube> f_104212_;
    @Mutable
    @Shadow
    @Final
    private Map<String, ModelPart> f_104213_;
    @Unique
    private ModelPart[] sodium$children;
    @Unique
    private ModelCuboid[] sodium$cuboids;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children, CallbackInfo ci) {
        ModelCuboid[] copies = new ModelCuboid[cuboids.size()];
        for (int i = 0; i < cuboids.size(); ++i) {
            ModelCuboidAccessor accessor = (ModelCuboidAccessor)cuboids.get(i);
            copies[i] = accessor.sodium$copy();
        }
        this.sodium$cuboids = copies;
        this.sodium$children = (ModelPart[])children.values().toArray(ModelPart[]::new);
        this.f_104212_ = Collections.unmodifiableList(this.f_104212_);
        this.f_104213_ = Collections.unmodifiableMap(this.f_104213_);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRender(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertices);
        if (writer == null) {
            return;
        }
        ci.cancel();
        EntityRenderer.render(matrices, writer, (ModelPart)this, light, overlay, ColorABGR.pack(red, green, blue, alpha));
    }

    @Overwrite
    public void m_104299_(PoseStack matrixStack) {
        if (this.f_104200_ != 0.0f || this.f_104201_ != 0.0f || this.f_104202_ != 0.0f) {
            matrixStack.m_252880_(this.f_104200_ * 0.0625f, this.f_104201_ * 0.0625f, this.f_104202_ * 0.0625f);
        }
        if (this.f_104203_ != 0.0f || this.f_104204_ != 0.0f || this.f_104205_ != 0.0f) {
            MatrixHelper.rotateZYX(matrixStack.m_85850_(), this.f_104205_, this.f_104204_, this.f_104203_);
        }
        if (this.f_233553_ != 1.0f || this.f_233554_ != 1.0f || this.f_233555_ != 1.0f) {
            matrixStack.m_85841_(this.f_233553_, this.f_233554_, this.f_233555_);
        }
    }

    @Override
    public ModelCuboid[] getCuboids() {
        return this.sodium$cuboids;
    }

    @Override
    public boolean isVisible() {
        return this.f_104207_;
    }

    @Override
    public boolean isHidden() {
        return this.f_233556_;
    }

    @Override
    public ModelPart[] getChildren() {
        return this.sodium$children;
    }
}

