/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.MidiParser;
import immersive_melodies.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class MelodyLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, LazyMelody>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final String dataType = "melodies";

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                val = value.updateAndGet(arg_0 -> MelodyLoader.lambda$memoize$0((Supplier)delegate, arg_0));
            }
            return val;
        };
    }

    protected Map<ResourceLocation, LazyMelody> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        Map resources = manager.m_214159_("melodies", path -> path.m_135815_().endsWith(".midi") || path.m_135815_().endsWith(".mid"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                String name = Utils.toTitle(Utils.removeLastPart(Utils.getLastPart(((ResourceLocation)entry.getKey()).m_135815_(), "/"), "."));
                ResourceLocation identifier = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_());
                map.put(identifier, new LazyMelody(name, () -> {
                    try {
                        return MidiParser.parseMidi(((Resource)entry.getValue()).m_215507_(), name);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load melody {} ({})", entry.getKey(), (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, LazyMelody> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ServerMelodyManager.setDatapackMelodies(prepared);
    }

    private static /* synthetic */ Object lambda$memoize$0(Supplier delegate, Object cur) {
        return cur == null ? Objects.requireNonNull(delegate.get()) : cur;
    }

    public static class LazyMelody {
        public final String name;
        public final Supplier<Melody> supplier;
        public final MelodyDescriptor descriptor;

        public LazyMelody(String name, Supplier<Melody> supplier) {
            this.name = name;
            this.supplier = MelodyLoader.memoize(supplier);
            this.descriptor = new MelodyDescriptor(name);
        }

        public Melody get() {
            return this.supplier.get();
        }

        public MelodyDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

