/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.resources.Note;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class Track {
    private final List<Note> notes;
    private final String name;

    public Track(String name, List<Note> notes) {
        this.name = name;
        this.notes = notes;
    }

    public Track(FriendlyByteBuf b) {
        this.name = b.m_130277_();
        int noteCount = b.readInt();
        this.notes = new LinkedList<Note>();
        for (int i = 0; i < noteCount; ++i) {
            this.notes.add(new Note(b));
        }
    }

    public List<Note> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public String getName() {
        return this.name;
    }

    public void encode(FriendlyByteBuf b) {
        b.m_130070_(this.name);
        b.writeInt(this.notes.size());
        for (Note note : this.notes) {
            note.encode(b);
        }
    }

    public int getLength() {
        if (this.notes.isEmpty()) {
            return 0;
        }
        Note note = this.notes.get(this.notes.size() - 1);
        return note.getTime() + note.getLength();
    }
}

