/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.make_bubbles_pop.impl;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPop;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPopConfig;

@OnlyIn(value=Dist.CLIENT)
public class BarrelBubbler {
    private BarrelBubbler() {
        throw new IllegalStateException("Utility class");
    }

    public static void spawnBubbles(Level world, BlockPos pos, Direction facing, RandomSource random) {
        if (world != null && world.f_46443_ && (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.BARREL_BUBBLES_ENABLED) && facing != Direction.DOWN) {
            for (int i = 0; i < 6 + random.m_188503_(12); ++i) {
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                float xOffsetRand = 0.0f;
                float yOffsetRand = 0.0f;
                float zOffsetRand = 0.0f;
                float xVelocityRand = 0.0f;
                float zVelocityRand = 0.0f;
                if (facing == Direction.NORTH) {
                    xOffset = 0.5f;
                    yOffset = 0.5f;
                    zOffset = -0.01f;
                    xOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    yOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    zVelocityRand = -random.m_188501_();
                } else if (facing == Direction.SOUTH) {
                    xOffset = 0.5f;
                    yOffset = 0.5f;
                    zOffset = 1.01f;
                    xOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    yOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    zVelocityRand = random.m_188501_();
                } else if (facing == Direction.EAST) {
                    xOffset = 1.01f;
                    yOffset = 0.5f;
                    zOffset = 0.5f;
                    yOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    zOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    xVelocityRand = random.m_188501_();
                } else if (facing == Direction.WEST) {
                    xOffset = -0.01f;
                    yOffset = 0.5f;
                    zOffset = 0.5f;
                    yOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    zOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    xVelocityRand = -random.m_188501_();
                } else if (facing == Direction.UP) {
                    xOffset = 0.5f;
                    yOffset = 1.01f;
                    zOffset = 0.5f;
                    xOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                    yOffsetRand = random.m_188501_() * 0.25f;
                    zOffsetRand = (random.m_188501_() - random.m_188501_()) * 0.3f;
                }
                world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)((float)pos.m_123341_() + xOffset + xOffsetRand), (double)((float)pos.m_123342_() + yOffset + yOffsetRand), (double)((float)pos.m_123343_() + zOffset + zOffsetRand), (double)xVelocityRand, (double)(0.05f + random.m_188501_() * 0.05f), (double)zVelocityRand);
            }
            if (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.CONTAINER_SOUND_ENABLED) {
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11776_, SoundSource.AMBIENT, 0.3f + random.m_188501_() * 0.1f, 1.3f + random.m_188501_() * 0.3f, false);
            }
        }
    }
}

