/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.make_bubbles_pop.mixin.client;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPop;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPopConfig;
import net.tschipcraft.make_bubbles_pop.impl.BubbleUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BubbleParticle.class})
public abstract class BubblePop
extends TextureSheetParticle {
    @Unique
    private float accelerationAngle;
    @Unique
    private byte accelerationTicker = 0;
    @Unique
    private byte routeDir = 0;

    protected BubblePop(ClientLevel clientLevel, double d, double e, double f) {
        super(clientLevel, d, e, f);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void makeBubblesPop$init(ClientLevel clientlevel, double d, double e, double f, double g, double h, double i, CallbackInfo ci) {
        this.f_107225_ = (int)((MakeBubblesPop.MIDNIGHTLIB_INSTALLED ? MakeBubblesPopConfig.BUBBLE_LIFETIME_MULTIPLIER : 32.0) / (this.f_107223_.m_188500_() * 0.7 + 0.1));
        this.accelerationAngle = this.f_107223_.m_188501_() * 360.0f;
        BubbleUtil.tintBubble((Level)this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, this);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void makeBubblesPop$tick(CallbackInfo ci) {
        ci.cancel();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_ || !this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + 0.1), (double)this.f_107214_)) || !this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))) {
            this.m_107274_();
            BubbleUtil.popBubble((Level)this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
        } else {
            this.f_107216_ += 0.01;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107213_ == this.f_107210_) {
                this.f_107224_ *= 2;
            }
            if (this.accelerationTicker == 0) {
                this.accelerationAngle = this.f_107223_.m_188501_() * 360.0f;
            }
            this.accelerationTicker = (byte)(this.accelerationTicker + 1);
            if (this.accelerationTicker % 5 == 0) {
                this.accelerationTicker = 0;
            }
            this.f_107215_ += (double)this.accelerationTicker / 10.0 * Math.cos(this.accelerationAngle) * 0.04;
            this.f_107217_ += (double)this.accelerationTicker / 10.0 * Math.sin(this.accelerationAngle) * 0.04;
            this.f_107215_ *= 0.7500000238418579;
            this.f_107216_ *= (double)0.85f;
            this.f_107217_ *= 0.7500000238418579;
            if (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.BUBBLE_PHYSICS_ENABLED) {
                List list = this.f_107208_.m_6249_((Entity)null, this.m_107277_().m_82400_(0.5), (Predicate)new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        return entity.m_6084_() && entity instanceof LivingEntity && !entity.f_19794_;
                    }
                });
                for (Entity entityIn : list) {
                    float zDiff;
                    float xDiff = (float)(this.f_107212_ - entityIn.m_20185_());
                    float absDiff = (float)Mth.m_14005_((double)xDiff, (double)(zDiff = (float)(this.f_107214_ - entityIn.m_20189_())));
                    if (!(absDiff >= 0.0099f)) continue;
                    absDiff = (float)Math.sqrt(absDiff);
                    xDiff /= absDiff;
                    zDiff /= absDiff;
                    float invertedDir = 1.0f / absDiff;
                    if (invertedDir > 1.0f) {
                        invertedDir = 1.0f;
                    }
                    this.f_107215_ += (double)(xDiff * invertedDir) / 20.0;
                    this.f_107217_ += (double)(zDiff * invertedDir) / 20.0;
                    this.f_107215_ += (entityIn.m_20184_().f_82479_ - this.f_107215_) * 0.2;
                    if (entityIn.m_20184_().f_82480_ != 0.419875) {
                        this.f_107216_ += (entityIn.m_20184_().f_82480_ - this.f_107216_) * 0.2;
                    }
                    this.f_107217_ += (entityIn.m_20184_().f_82481_ - this.f_107217_) * 0.2;
                }
                if (!this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + 0.8), (double)this.f_107214_)) && !this.f_107208_.m_46859_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + 0.8), (double)this.f_107214_))) {
                    boolean escapeNegZ;
                    boolean escapePosX = this.f_107208_.m_46801_(BlockPos.m_274561_((double)(this.f_107212_ + 1.0), (double)(this.f_107213_ + 0.8), (double)this.f_107214_)) && this.f_107208_.m_46801_(BlockPos.m_274561_((double)(this.f_107212_ + 1.0), (double)this.f_107213_, (double)this.f_107214_));
                    boolean escapeNegX = this.f_107208_.m_46801_(BlockPos.m_274561_((double)(this.f_107212_ - 1.0), (double)(this.f_107213_ + 0.8), (double)this.f_107214_)) && this.f_107208_.m_46801_(BlockPos.m_274561_((double)(this.f_107212_ - 1.0), (double)this.f_107213_, (double)this.f_107214_));
                    boolean escapePosZ = this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + 0.8), (double)(this.f_107214_ + 1.0))) && this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)(this.f_107214_ + 1.0)));
                    boolean bl = escapeNegZ = this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + 0.8), (double)(this.f_107214_ - 1.0))) && this.f_107208_.m_46801_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)(this.f_107214_ - 1.0)));
                    if (escapePosX || escapeNegX || escapePosZ || escapeNegZ) {
                        for (int i = 0; i <= 5; ++i) {
                            if (escapePosX && this.routeDir == 1) {
                                this.f_107215_ += 0.03;
                                break;
                            }
                            if (escapeNegX && this.routeDir == 2) {
                                this.f_107215_ -= 0.03;
                                break;
                            }
                            if (escapePosZ && this.routeDir == 3) {
                                this.f_107217_ += 0.03;
                                break;
                            }
                            if (escapeNegZ && this.routeDir == 4) {
                                this.f_107217_ -= 0.03;
                                break;
                            }
                            this.routeDir = (byte)(this.f_107223_.m_188500_() * 4.0 + 1.0);
                        }
                    }
                } else {
                    this.routeDir = 0;
                }
            }
        }
    }
}

