/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.make_bubbles_pop.mixin.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPop;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPopConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChestBlockEntity.class})
public abstract class ChestBubble {
    @Unique
    private static final List<BlockPos> OPENED_CHESTS = new ArrayList<BlockPos>();

    @Inject(method={"lidAnimateTick"}, at={@At(value="TAIL")})
    private static void makeBubblesPop$clientTick(Level world, BlockPos pos, BlockState state, ChestBlockEntity blockEntity, CallbackInfo ci) {
        if (world != null && world.f_46443_ && (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.CHEST_BUBBLES_ENABLED) && world.m_46801_(pos)) {
            boolean doubleChest;
            ChestType chestType = state.m_61145_((Property)BlockStateProperties.f_61392_).orElse(ChestType.SINGLE);
            Direction facing = state.m_61145_((Property)ChestBlock.f_51478_).orElse(Direction.NORTH);
            Block block = state.m_60734_();
            boolean bl = doubleChest = chestType != ChestType.SINGLE;
            if (block instanceof AbstractChestBlock) {
                float openFactor = blockEntity.m_6683_(1.0f);
                if (openFactor > 0.0f) {
                    if (!OPENED_CHESTS.contains(pos)) {
                        OPENED_CHESTS.add(pos);
                        if (doubleChest) {
                            if (chestType == ChestType.LEFT) {
                                for (int i = 0; i < 15 + world.f_46441_.m_188503_(20); ++i) {
                                    float xOffset = 0.0f;
                                    float zOffset = 0.0f;
                                    float xOffsetRand = 0.0f;
                                    float zOffsetRand = 0.0f;
                                    if (facing == Direction.NORTH) {
                                        xOffset = 1.0f;
                                        zOffset = 0.5f;
                                        xOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f;
                                        zOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f;
                                    } else if (facing == Direction.SOUTH) {
                                        xOffset = 0.0f;
                                        zOffset = 0.5f;
                                        xOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f;
                                        zOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f;
                                    } else if (facing == Direction.EAST) {
                                        xOffset = 0.5f;
                                        zOffset = 1.0f;
                                        xOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f;
                                        zOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f;
                                    } else if (facing == Direction.WEST) {
                                        xOffset = 0.5f;
                                        zOffset = 0.0f;
                                        xOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f;
                                        zOffsetRand = (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f;
                                    }
                                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)((float)pos.m_123341_() + xOffset + xOffsetRand), (double)((float)pos.m_123342_() + 0.7f - world.f_46441_.m_188501_() / 2.0f), (double)((float)pos.m_123343_() + zOffset + zOffsetRand), 0.0, (double)(0.05f + world.f_46441_.m_188501_() * 0.05f), 0.0);
                                }
                            }
                        } else {
                            for (int i = 0; i < 7 + world.f_46441_.m_188503_(10); ++i) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)((float)pos.m_123341_() + 0.5f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f), (double)((float)pos.m_123342_() + 0.7f - world.f_46441_.m_188501_() / 2.0f), (double)((float)pos.m_123343_() + 0.5f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.3f), 0.0, (double)(0.05f + world.f_46441_.m_188501_() * 0.05f), 0.0);
                            }
                        }
                        if (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.CONTAINER_SOUND_ENABLED) {
                            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11776_, SoundSource.AMBIENT, 0.3f + world.f_46441_.m_188501_() * 0.1f, 1.3f + world.f_46441_.m_188501_() * 0.3f, false);
                        }
                    }
                } else {
                    OPENED_CHESTS.remove(pos);
                }
            }
        }
    }
}

