/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.utils;

import cn.mcmod_mmf.mmlib.Main;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.DataGenUtil;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtil {
    public static final HashMap<ResourceLocation, BedrockModelPOJO> MODEL_MAP = Maps.newHashMap();

    @OnlyIn(value=Dist.CLIENT)
    public static void loadModel(ResourceLocation modelLocation, JsonElement element) {
        BedrockModelPOJO pojo = (BedrockModelPOJO)DataGenUtil.DATA_GSON.fromJson(element, BedrockModelPOJO.class);
        if (pojo.getFormatVersion() == null) {
            Main.getLogger().error("Failed to load model: {}, it's not a Bedrock Model!", (Object)modelLocation);
            return;
        }
        if (pojo.getFormatVersion().equals("1.10.0")) {
            if (pojo.getGeometryModelLegacy() != null) {
                Main.getLogger().info("Loaded 1.10.0 version model : {}", (Object)modelLocation);
                MODEL_MAP.put(modelLocation, pojo);
                return;
            }
            Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
            return;
        }
        if (pojo.getFormatVersion().equals("1.12.0")) {
            if (pojo.getGeometryModelNew() != null) {
                MODEL_MAP.put(modelLocation, pojo);
                Main.getLogger().info("Loaded 1.12.0 version model : {}", (Object)modelLocation);
                return;
            }
            Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
            return;
        }
        Main.getLogger().error("{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BedrockModelPOJO getModelPOJO(ResourceLocation modelLocation) {
        return MODEL_MAP.get(modelLocation);
    }

    public static float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

