/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Elephant;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class ElephantModel
extends GeoModel<Elephant> {
    public ResourceLocation getModelResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "geo/elephant.geo.json");
    }

    public ResourceLocation getTextureResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "textures/entity/elephant.png");
    }

    public ResourceLocation getAnimationResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "animations/elephant.animation.json");
    }

    public void setCustomAnimations(Elephant animatable, long instanceId, AnimationState<Elephant> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone bigTusks = this.getAnimationProcessor().getBone("tusks");
        CoreGeoBone smallTusks = this.getAnimationProcessor().getBone("baby_tusks");
        CoreGeoBone babyTrunk = this.getAnimationProcessor().getBone("trunk4");
        CoreGeoBone leftEar = this.getAnimationProcessor().getBone("left_ear");
        CoreGeoBone rightEar = this.getAnimationProcessor().getBone("right_ear");
        if (animatable.m_6162_()) {
            head.setScaleX(1.3f);
            head.setScaleY(1.3f);
            head.setScaleZ(1.3f);
            leftEar.setScaleX(1.2f);
            leftEar.setScaleY(1.2f);
            leftEar.setScaleZ(1.2f);
            rightEar.setScaleX(1.2f);
            rightEar.setScaleY(1.2f);
            rightEar.setScaleZ(1.2f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
            leftEar.setScaleX(1.0f);
            leftEar.setScaleY(1.0f);
            leftEar.setScaleZ(1.0f);
            rightEar.setScaleX(1.0f);
            rightEar.setScaleY(1.0f);
            rightEar.setScaleZ(1.0f);
        }
        bigTusks.setHidden(animatable.m_6162_());
        smallTusks.setHidden(animatable.m_6162_());
        smallTusks.setHidden(!animatable.m_6162_());
        babyTrunk.setHidden(animatable.m_6162_());
        head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
    }
}

