/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ClimbingAnimal;
import com.starfish_studios.naturalist.common.entity.core.SleepingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SearchForItemsGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Snake
extends ClimbingAnimal
implements SleepingAnimal,
NeutralMob,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.SNAKE_TEMPT_ITEMS);
    private static final Ingredient TAME_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.SNAKE_TAME_ITEMS);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Snake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(Snake.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EAT_COUNTER = SynchedEntityData.m_135353_(Snake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID persistentAngerTarget;

    public Snake(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Snake.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SnakeMeleeAttackGoal((PathfinderMob)this, 1.75, true));
        this.f_21345_.m_25352_(2, (Goal)new SearchForItemsGoal((PathfinderMob)this, 1.2f, FOOD_ITEMS, 8.0, 8.0));
        this.f_21345_.m_25352_(3, new SleepGoal<Snake>(this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Snake)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, false, livingEntity -> {
            Slime slime;
            return livingEntity.m_6095_().m_204039_(NaturalistTags.EntityTypes.SNAKE_HOSTILES) || livingEntity instanceof Slime && (slime = (Slime)livingEntity).m_33633_();
        }));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public static boolean checkSnakeSpawnRules(EntityType<Snake> entityType, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_) && Snake.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(this.f_19796_, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance pDifficulty) {
        if (random.m_188501_() < 0.2f) {
            float chance = random.m_188501_();
            ItemStack stack = chance < 0.05f ? new ItemStack((ItemLike)Items.f_42648_) : (chance < 0.1f ? new ItemStack((ItemLike)Items.f_42518_) : (chance < 0.15f ? new ItemStack((ItemLike)Items.f_42402_) : (chance < 0.3f ? new ItemStack((ItemLike)Items.f_42697_) : new ItemStack((ItemLike)Items.f_42581_))));
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public boolean isTameFood(ItemStack pStack) {
        return TAME_ITEMS.test(pStack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(EAT_COUNTER, (Object)0);
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public boolean isEating() {
        return (Integer)this.f_19804_.m_135370_(EAT_COUNTER) > 0;
    }

    public void eat(boolean eat) {
        this.f_19804_.m_135381_(EAT_COUNTER, (Object)(eat ? 1 : 0));
    }

    private int getEatCounter() {
        return (Integer)this.f_19804_.m_135370_(EAT_COUNTER);
    }

    private void setEatCounter(int amount) {
        this.f_19804_.m_135381_(EAT_COUNTER, (Object)amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        this.handleEating();
        if (!this.m_21205_().m_41619_() && this.m_21660_()) {
            this.m_21662_();
        }
        if (this.canRattle() && !this.m_5803_()) {
            this.m_5496_(NaturalistSoundEvents.SNAKE_RATTLE.get(), 0.15f, 1.0f);
        }
    }

    private void handleEating() {
        if (!(this.isEating() || this.m_5803_() || this.m_21205_().m_41619_())) {
            this.eat(true);
        } else if (this.m_21205_().m_41619_()) {
            this.eat(false);
        }
        if (this.isEating()) {
            if (!this.m_9236_().f_46443_ && this.getEatCounter() > 6000) {
                if (!this.m_21205_().m_41619_() && !this.m_9236_().f_46443_) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.m_146850_(GameEvent.f_157806_);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot slot = Snake.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack stack = pItemEntity.m_32055_();
        if (this.m_21205_().m_41619_() && FOOD_ITEMS.test(stack)) {
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, stack.m_41613_());
            pItemEntity.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_21205_().m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, this.m_21205_());
            itemEntity.m_32010_(80);
            itemEntity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    public float m_6113_() {
        return this.m_21205_().m_41619_() ? super.m_6113_() : super.m_6113_() * 0.5f;
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.m_9236_().m_46468_();
        if (this.m_21660_() || this.m_9236_().m_46801_(this.m_20183_())) {
            return false;
        }
        if (dayTime > 18000L && dayTime < 23000L) {
            return false;
        }
        return dayTime > 12000L && dayTime < 28000L;
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public boolean m_7327_(Entity pEntity) {
        if ((this.m_6095_().equals(NaturalistEntityTypes.CORAL_SNAKE.get()) || this.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get())) && pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40));
        }
        return super.m_7327_(pEntity);
    }

    private boolean canRattle() {
        List players = this.m_9236_().m_45955_(TargetingConditions.m_148353_().m_26883_(4.0), (LivingEntity)this, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
        if (!players.isEmpty() && this.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get()) && !((Player)players.get(0)).m_7500_()) {
            this.m_6710_((LivingEntity)players.get(0));
        } else {
            this.m_6710_(null);
        }
        return !players.isEmpty() && this.m_6095_().equals(NaturalistEntityTypes.RATTLESNAKE.get());
    }

    protected float m_6121_() {
        return 0.15f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return NaturalistSoundEvents.SNAKE_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Snake> PlayState predicate(AnimationState<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("snake.sleep"));
            return PlayState.CONTINUE;
        }
        if (this.isClimbing()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("snake.climb"));
            return PlayState.CONTINUE;
        }
        if (!(event.getLimbSwingAmount() > -0.04f) || !(event.getLimbSwingAmount() < 0.04f)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("snake.move"));
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private <E extends Snake> PlayState attackPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("snake.attack"));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private <E extends Snake> PlayState tonguePredicate(AnimationState<E> event) {
        if (this.f_19796_.m_188503_(1000) < this.f_21363_ && !this.m_5803_() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("snake.tongue"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends Snake> PlayState rattlePredicate(AnimationState<E> event) {
        if (this.canRattle() && !this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("snake.rattle"));
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private void soundListener(SoundKeyframeEvent<Snake> event) {
        Snake snake = (Snake)event.getAnimatable();
        if (snake.m_9236_().f_46443_ && event.getKeyframeData().getSound().equals("hiss")) {
            snake.m_9236_().m_7785_(snake.m_20185_(), snake.m_20186_(), snake.m_20189_(), NaturalistSoundEvents.SNAKE_HISS.get(), snake.m_5720_(), snake.m_6121_(), snake.m_6100_(), false);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
        AnimationController tongueController = new AnimationController((GeoAnimatable)this, "tongueController", 0, this::tonguePredicate);
        tongueController.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{tongueController});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rattleController", 0, this::rattlePredicate)});
    }

    static class SnakeMeleeAttackGoal
    extends MeleeAttackGoal {
        private long lastCanUseCheck;
        private Path path;

        public SnakeMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            return this.f_25540_.m_21205_().m_41619_() && this.testUse();
        }

        boolean testUse() {
            long l = this.f_25540_.m_9236_().m_46467_();
            if (l - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = l;
            LivingEntity livingEntity = this.f_25540_.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            this.path = this.f_25540_.m_21573_().m_6570_((Entity)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.m_6639_(livingEntity) >= this.f_25540_.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        }

        public boolean m_8045_() {
            return this.f_25540_.m_21205_().m_41619_() && super.m_8045_();
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return 4.0f + pAttackTarget.m_20205_();
        }
    }
}

