/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.blocks.forge.MicrowaveBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MicrowaveBlock
extends HorizontalFacingBlockWithEntity
implements DynamicRenderLayerInterface {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> MICROWAVES = new ArrayList<FurnitureBlock>();
    private final VoxelShape MICROWAVE = Shapes.m_83110_((VoxelShape)MicrowaveBlock.m_49796_((double)1.8, (double)0.0, (double)3.8, (double)14.2, (double)1.0, (double)13.2), (VoxelShape)MicrowaveBlock.m_49796_((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)7.0, (double)13.0));
    private final VoxelShape MICROWAVE_OPEN = Shapes.m_83124_((VoxelShape)MicrowaveBlock.m_49796_((double)1.8, (double)0.0, (double)3.8, (double)14.2, (double)1.0, (double)13.2), (VoxelShape[])new VoxelShape[]{MicrowaveBlock.m_49796_((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)7.0, (double)13.0), MicrowaveBlock.m_49796_((double)2.0, (double)1.0, (double)13.0, (double)3.1, (double)7.0, (double)20.9)});
    private final VoxelShape MICROWAVE_SOUTH = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.SOUTH, this.MICROWAVE);
    private final VoxelShape MICROWAVE_SOUTH_OPEN = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.SOUTH, this.MICROWAVE_OPEN);
    private final VoxelShape MICROWAVE_EAST = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.EAST, this.MICROWAVE);
    private final VoxelShape MICROWAVE_EAST_OPEN = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.EAST, this.MICROWAVE_OPEN);
    private final VoxelShape MICROWAVE_WEST = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.WEST, this.MICROWAVE);
    private final VoxelShape MICROWAVE_WEST_OPEN = ClassicChairBlock.rotateShape(Direction.NORTH, Direction.WEST, this.MICROWAVE_OPEN);

    public MicrowaveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        MICROWAVES.add(new FurnitureBlock((Block)this, "microwave"));
    }

    public static Stream<FurnitureBlock> streamMicrowaves() {
        return MICROWAVES.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
        stateManager.m_61104_(new Property[]{POWERED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            MicrowaveBlock.openScreen(player, state, world, pos);
            player.m_36220_(Statistics.MICROWAVE_USED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openScreen(Player player, BlockState state, Level world, BlockPos pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        MicrowaveBlockImpl.openScreen(player, (BlockState)var1_1, (Level)var2_2, (BlockPos)var3_3);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return MicrowaveBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return MicrowaveBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof MicrowaveBlockEntity) {
            ((MicrowaveBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return MicrowaveBlock.checkType(world, type, BlockEntities.MICROWAVE_BLOCK_ENTITY);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> checkType(Level world, BlockEntityType<T> givenType, BlockEntityType<? extends MicrowaveBlockEntity> expectedType) {
        return world.f_46443_ ? null : MicrowaveBlock.m_152132_(givenType, expectedType, MicrowaveBlockEntity::tick);
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    return this.MICROWAVE_OPEN;
                }
                return this.MICROWAVE;
            }
            case SOUTH: {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    return this.MICROWAVE_SOUTH_OPEN;
                }
                return this.MICROWAVE_SOUTH;
            }
            case EAST: {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    return this.MICROWAVE_EAST_OPEN;
                }
                return this.MICROWAVE_EAST;
            }
            case WEST: {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    return this.MICROWAVE_WEST_OPEN;
                }
                return this.MICROWAVE_WEST;
            }
        }
        return this.MICROWAVE;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public RenderType getCustomRenderLayer() {
        return RenderType.m_110466_();
    }
}

