/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.runtime.data.PFMRecipeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBakedModel
implements BakedModel {
    protected final ModelState settings;
    private final List<BakedModel> templateBakedModels;
    Map<Block, VariantBase<?>> blockVariantMap = new HashMap();
    private final Map<BlockItem, BlockState> blockItemBlockStateMap = new HashMap<BlockItem, BlockState>();
    private final Map<Block, List<TextureAtlasSprite>> spriteList = new HashMap<Block, List<TextureAtlasSprite>>();

    public AbstractBakedModel(ModelState settings, List<BakedModel> templateBakedModels) {
        this.settings = settings;
        this.templateBakedModels = templateBakedModels;
    }

    public List<BakedModel> getTemplateBakedModels() {
        return this.templateBakedModels;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemTransforms m_7442_() {
        return this.templateBakedModels.get(0).m_7442_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    protected VariantBase<?> getVariant(BlockState state) {
        VariantBase<?> variant;
        if (this.blockVariantMap.containsKey(state.m_60734_())) {
            variant = this.blockVariantMap.get(state.m_60734_());
        } else {
            variant = PaladinFurnitureMod.furnitureEntryMap.get(state.m_60734_().getClass()).getVariantFromEntry(state.m_60734_());
            this.blockVariantMap.put(state.m_60734_(), variant);
        }
        return variant;
    }

    public <T> List<TextureAtlasSprite> getSpriteList(T element) {
        if (element instanceof BlockState) {
            BlockState state = (BlockState)element;
            return this.getSpriteFromState(state);
        }
        if (element instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)element;
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            BlockState state = blockItem.m_40614_().m_49966_();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element instanceof Block) {
            Block block = (Block)element;
            if (this.spriteList.containsKey(block)) {
                return this.spriteList.get(block);
            }
            BlockState state = block.m_49966_();
            return this.getSpriteFromState(state);
        }
        if (element instanceof ItemStack && ((ItemStack)element).m_41720_() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)((ItemStack)element).m_41720_();
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            BlockState state = blockItem.m_40614_().m_49966_();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element == null) {
            return Collections.singletonList(this.getTemplateBakedModels().get(0).m_6160_());
        }
        PaladinFurnitureMod.GENERAL_LOGGER.error("Invalid element for sprite list method");
        return Collections.singletonList(this.getTemplateBakedModels().get(0).m_6160_());
    }

    protected List<TextureAtlasSprite> getBedSprites(DyeColor color, BlockState state) {
        ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>(3);
        VariantBase<?> variant = this.getVariant(state);
        return list;
    }

    private List<TextureAtlasSprite> getSpriteFromState(BlockState state) {
        if (this.spriteList.containsKey(state.m_60734_())) {
            return this.spriteList.get(state.m_60734_());
        }
        VariantBase<?> variant = this.getVariant(state);
        boolean stripped = state.m_60734_().m_7705_().contains("stripped");
        ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>(3);
        if (state.m_60734_() instanceof SimpleBedBlock) {
            DyeColor color = ModelHelper.getColor(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()));
            Material mainTexture = new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.PLANKS));
            Material spriteIdentifier = Sheets.f_110744_[color.m_41060_()];
            list.add(mainTexture.m_119204_());
            list.add(spriteIdentifier.m_119204_());
        } else if (state.m_60734_() instanceof LogStoolBlock) {
            mainTexture = stripped ? new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.LOG));
            secondTexture = stripped ? new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG_TOP)) : new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.LOG_TOP));
            list.add(mainTexture.m_119204_());
            list.add(secondTexture.m_119204_());
        } else if (!state.m_60734_().m_7705_().contains("_raw_")) {
            mainTexture = stripped ? new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.PRIMARY));
            secondTexture = stripped ? new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.PRIMARY)) : new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.m_119204_());
            list.add(secondTexture.m_119204_());
        } else {
            mainTexture = stripped ? new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG)) : new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.m_119204_());
            list.add(mainTexture.m_119204_());
        }
        boolean isKitchen = state.m_60734_().m_7705_().contains("kitchen_");
        if (isKitchen && !(variant instanceof WoodVariant)) {
            Tuple<Block, Block> counterMaterials = PFMRecipeProvider.getCounterMaterials(variant);
            Material mainTexture = new Material(InventoryMenu.f_39692_, ModelHelper.getTextureId((Block)counterMaterials.m_14418_()));
            Material secondTexture = new Material(InventoryMenu.f_39692_, ModelHelper.getTextureId((Block)counterMaterials.m_14419_()));
            list.set(0, mainTexture.m_119204_());
            list.set(1, secondTexture.m_119204_());
        }
        this.spriteList.put(state.m_60734_(), list);
        return list;
    }
}

