/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.imm_ptl.forge.entity;

import com.unlikepaladin.pfm.compat.imm_ptl.forge.PFMImmersivePortalsImpl;
import com.unlikepaladin.pfm.compat.imm_ptl.forge.PFMMirrorBlockIP;
import com.unlikepaladin.pfm.compat.imm_ptl.forge.shape.BlockPortalShape;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class PFMMirrorEntity
extends Mirror {
    @Nullable
    public IntBox wallArea;
    @Nullable
    public BlockPortalShape blockPortalShape;
    public boolean unbreakable = false;
    private Direction facing;

    public PFMMirrorEntity(EntityType<PFMMirrorEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.wallArea = tag.m_128441_("boxXL") ? new IntBox(new BlockPos(tag.m_128451_("boxXL"), tag.m_128451_("boxYL"), tag.m_128451_("boxZL")), new BlockPos(tag.m_128451_("boxXH"), tag.m_128451_("boxYH"), tag.m_128451_("boxZH"))) : null;
        this.blockPortalShape = tag.m_128441_("blockPortalShape") ? BlockPortalShape.fromTag(tag.m_128469_("blockPortalShape")) : null;
        if (tag.m_128441_("unbreakable")) {
            this.unbreakable = tag.m_128471_("unbreakable");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.wallArea != null) {
            tag.m_128405_("boxXL", this.wallArea.l.m_123341_());
            tag.m_128405_("boxYL", this.wallArea.l.m_123342_());
            tag.m_128405_("boxZL", this.wallArea.l.m_123343_());
            tag.m_128405_("boxXH", this.wallArea.h.m_123341_());
            tag.m_128405_("boxYH", this.wallArea.h.m_123342_());
            tag.m_128405_("boxZH", this.wallArea.h.m_123343_());
        }
        if (this.blockPortalShape != null) {
            tag.m_128365_("blockPortalShape", (Tag)this.blockPortalShape.toTag());
        }
        tag.m_128379_("unbreakable", this.unbreakable);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20193_().f_46443_ && !this.unbreakable && this.m_20193_().m_46467_() % 10L == (long)(this.m_19879_() % 10)) {
            this.checkWallIntegrity();
        }
    }

    public boolean isPortalValid() {
        return super.isPortalValid() && (this.wallArea != null || this.blockPortalShape != null);
    }

    private void checkWallIntegrity() {
        if (this.facing == null && this.m_20193_().m_8055_(this.m_20183_()).m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.facing = ((Direction)this.m_20193_().m_8055_(this.m_20183_()).m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        } else if (this.facing == null) {
            this.facing = Direction.NORTH;
        }
        boolean wallValid = this.wallArea != null ? this.wallArea.fastStream().allMatch(blockPos -> PFMMirrorEntity.isMirrorBlock(this.m_20193_(), blockPos, this.facing.m_122424_())) : (this.blockPortalShape != null ? this.blockPortalShape.area.stream().allMatch(blockPos -> PFMMirrorEntity.isMirrorBlock(this.m_20193_(), blockPos, this.facing.m_122424_())) : false);
        if (!wallValid) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static boolean isMirrorBlock(Level world, BlockPos blockPos, Direction facing) {
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return blockState.m_60734_() instanceof PFMMirrorBlockIP && ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).equals((Object)facing);
        }
        return false;
    }

    public static void createMirror(ServerLevel world, BlockPos glassPos, Direction facing) {
        if (!PFMMirrorEntity.isMirrorBlock((Level)world, glassPos, facing.m_122424_())) {
            return;
        }
        BlockPortalShape shape = BlockPortalShape.findArea(glassPos, facing.m_122434_(), blockPos -> PFMMirrorEntity.isMirrorBlock((Level)world, blockPos, facing.m_122424_()), blockPos -> !PFMMirrorEntity.isMirrorBlock((Level)world, blockPos, facing.m_122424_()));
        if (shape == null) {
            return;
        }
        PFMMirrorEntity pfmMirrorEntity = (PFMMirrorEntity)PFMImmersivePortalsImpl.MIRROR.m_20615_((Level)world);
        double distanceToCenter = -0.452;
        AABB wallBox = PFMMirrorEntity.getWallBox((Level)world, shape.area.stream());
        if (wallBox == null) {
            return;
        }
        pfmMirrorEntity.facing = facing;
        Vec3 pos = Helper.getBoxSurfaceInversed((AABB)wallBox, (Direction)facing.m_122424_()).m_82399_();
        pos = Helper.putCoordinate((Vec3)pos, (Direction.Axis)facing.m_122434_(), (double)Helper.getCoordinate((Vec3)shape.innerAreaBox.getCenterVec().m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(distanceToCenter)), (Direction.Axis)facing.m_122434_()));
        pfmMirrorEntity.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        pfmMirrorEntity.setDestination(pos);
        pfmMirrorEntity.dimensionTo = world.m_46472_();
        shape.initPortalAxisShape((Portal)pfmMirrorEntity, pos, facing);
        pfmMirrorEntity.blockPortalShape = shape;
        world.m_7967_((Entity)pfmMirrorEntity);
    }

    @Nullable
    public static AABB getWallBox(Level world, Stream<BlockPos> blockPosStream) {
        return blockPosStream.map(blockPos -> {
            VoxelShape collisionShape = world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos);
            if (collisionShape.m_83281_()) {
                return null;
            }
            return collisionShape.m_83215_().m_82383_(Vec3.m_82528_((Vec3i)blockPos));
        }).filter(b -> b != null).reduce(AABB::m_82367_).orElse(null);
    }
}

