/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExtraCounterVariant
extends VariantBase<ExtraCounterVariant> {
    public static ExtraCounterVariant DARK_CONCRETE = new ExtraCounterVariant(Blocks.f_50497_, Blocks.f_50542_, "dark_concrete");
    public static ExtraCounterVariant CONCRETE = new ExtraCounterVariant(Blocks.f_50542_, null, "concrete");
    public static ExtraCounterVariant SMOOTH_STONE = new ExtraCounterVariant(Blocks.f_50542_, Blocks.f_50470_, "smooth_stone");
    public static ExtraCounterVariant DEEPSLATE_TILE = new ExtraCounterVariant(Blocks.f_50333_, Blocks.f_152559_, "deepslate_tile");
    private final String name;
    private final Block baseBlock;
    static final List<ExtraCounterVariant> DEFAULT_VARIANTS = new ArrayList<ExtraCounterVariant>();
    private final Block secondaryBlock;

    public static List<ExtraCounterVariant> values() {
        if (DEFAULT_VARIANTS.isEmpty()) {
            DEFAULT_VARIANTS.add(DARK_CONCRETE);
            DEFAULT_VARIANTS.add(CONCRETE);
            DEFAULT_VARIANTS.add(SMOOTH_STONE);
            DEFAULT_VARIANTS.add(DEEPSLATE_TILE);
        }
        return DEFAULT_VARIANTS;
    }

    ExtraCounterVariant(ResourceLocation identifier, Block baseBlock, Block secondaryBlock) {
        super(identifier);
        this.name = identifier.m_135815_();
        this.baseBlock = baseBlock;
        this.secondaryBlock = secondaryBlock;
    }

    ExtraCounterVariant(Block baseBlock, Block secondaryBlock, String name) {
        this(new ResourceLocation("", name), baseBlock, secondaryBlock);
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        if (this.secondaryBlock == null) {
            return PaladinFurnitureModBlocksItems.RAW_CONCRETE;
        }
        return this.secondaryBlock;
    }

    @Override
    public boolean isNetherWood() {
        return false;
    }

    @Override
    public ExtraCounterVariant getVariantType() {
        return this;
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.m_135827_().equals("") || this.identifier.m_135827_().equals("minecraft");
    }

    @Override
    public void initializeChildrenBlocks() {
    }

    @Override
    public void initializeChildrenItems() {
    }

    @Override
    public List<FeatureFlag> getFeatureList() {
        FeatureFlag flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().m_245183_().f_243923_, 0);
        flag.f_244012_ = this.getBaseBlock().m_245183_().f_243922_;
        return List.of(flag);
    }

    @Override
    public Block mainChild() {
        return this.baseBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.getSecondaryBlock());
        }
        return ModelHelper.getTextureId(this.baseBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.m_135815_();
    }
}

