/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorkbenchScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final List<FurnitureRecipe> availableRecipes = Lists.newArrayList();
    private static final List<FurnitureRecipe> allRecipes = Lists.newArrayList();
    private final List<FurnitureRecipe> sortedRecipes = Lists.newArrayList();
    private final List<FurnitureRecipe> searchableRecipes = Lists.newArrayList();
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    final Slot outputSlot;
    final ResultContainer output = new ResultContainer();
    long lastTakeTime;
    final Inventory playerInventory;
    Runnable contentsChangedListener;
    public boolean searching = false;

    public WorkbenchScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WorkbenchScreenHandler(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(ScreenHandlerIDs.WORKBENCH_SCREEN_HANDLER, syncId);
        int i;
        this.context = context;
        this.world = playerInventory.f_35978_.m_9236_();
        this.playerInventory = playerInventory;
        this.contentsChangedListener = () -> {};
        this.outputSlot = this.m_38897_(new Slot((Container)this.output, 0, 143, 50){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (WorkbenchScreenHandler.this.craft()) {
                    stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                    WorkbenchScreenHandler.this.output.m_58395_(player, List.of());
                    WorkbenchScreenHandler.this.populateResult(player);
                    context.m_39292_((world, pos) -> {
                        long l = world.m_46467_();
                        if (WorkbenchScreenHandler.this.lastTakeTime != l) {
                            world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            WorkbenchScreenHandler.this.lastTakeTime = l;
                        }
                    });
                    WorkbenchScreenHandler.this.contentsChangedListener.run();
                    WorkbenchScreenHandler.this.updateInput();
                    super.m_142406_(player, stack);
                }
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 98 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 156));
        }
        this.m_38895_(this.selectedRecipe);
        if (allRecipes.isEmpty()) {
            allRecipes.addAll(this.world.m_7465_().m_44013_(RecipeTypes.FURNITURE_RECIPE).stream().sorted().toList());
        }
        this.updateInput();
        this.selectedRecipe.m_6422_(-1);
    }

    boolean craft() {
        FurnitureRecipe furnitureRecipe;
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.m_6501_()) && (furnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.m_6501_())).matches(this.playerInventory, this.playerInventory.f_35978_.m_9236_())) {
            NonNullList<Ingredient> ingredients = furnitureRecipe.m_7527_();
            block0: for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    int indexOfStack;
                    if (FurnitureRecipe.getSlotWithStackIgnoreNBT(this.playerInventory, stack) == -1 || this.playerInventory.m_8020_(indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(this.playerInventory, stack)).m_41613_() < stack.m_41613_()) continue;
                    ItemStack stack1 = this.playerInventory.m_8020_(indexOfStack);
                    stack1.m_41774_(stack.m_41613_());
                    this.playerInventory.m_6836_(indexOfStack, stack1);
                    this.playerInventory.m_6596_();
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    void populateResult(Player player) {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.m_6501_())) {
            FurnitureRecipe furnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.m_6501_());
            this.outputSlot.m_269060_(furnitureRecipe.craft(player.m_150109_(), player.m_9236_().m_9598_()));
        } else {
            this.outputSlot.m_269060_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public boolean isInBounds(List<FurnitureRecipe> furnitureRecipes, int id) {
        if (id >= furnitureRecipes.size() || id < 0) {
            return false;
        }
        return furnitureRecipes.contains(this.getSortedRecipes().get(id));
    }

    public void m_6199_(Container inventory) {
        this.updateInput();
        super.m_6199_(inventory);
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<FurnitureRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public List<FurnitureRecipe> getSortedRecipes() {
        return this.sortedRecipes;
    }

    public List<FurnitureRecipe> getAllRecipes() {
        return allRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public int getTotalRecipeCount() {
        return this.sortedRecipes.size();
    }

    public int getVisibleRecipeCount() {
        return this.searching ? this.searchableRecipes.size() : this.getTotalRecipeCount();
    }

    public void updateInput() {
        if (!this.availableRecipes.isEmpty() && this.getSelectedRecipe() != -1 && !this.sortedRecipes.get(this.getSelectedRecipe()).matches(this.playerInventory, this.world)) {
            this.selectedRecipe.m_6422_(-1);
            this.outputSlot.m_269060_(ItemStack.f_41583_);
        }
        this.availableRecipes.clear();
        this.availableRecipes.addAll(allRecipes.stream().filter(newFurnitureRecipe -> newFurnitureRecipe.matches(this.playerInventory, this.world)).toList());
        this.sortedRecipes.clear();
        this.sortedRecipes.addAll(this.availableRecipes);
        this.sortedRecipes.addAll(allRecipes.stream().filter(furnitureRecipe -> !this.sortedRecipes.contains(furnitureRecipe)).toList());
    }

    public boolean canCraft() {
        return !this.availableRecipes.isEmpty();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean m_6875_(Player player) {
        return WorkbenchScreenHandler.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)PaladinFurnitureModBlocksItems.WORKING_TABLE);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.outputSlot && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (index == 0) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index >= 1 && index < 28 ? !this.m_38903_(itemStack2, 28, 37, false) : index >= 28 && index < 37 && !this.m_38903_(itemStack2, 1, 28, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public boolean m_6366_(Player player, int id) {
        this.updateInput();
        if (this.isInBounds(this.availableRecipes, id) && this.canCraft()) {
            this.selectedRecipe.m_6422_(id);
            this.populateResult(player);
            return true;
        }
        return false;
    }

    public List<FurnitureRecipe> getSearchableRecipes() {
        return this.searchableRecipes;
    }
}

