/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FurnitureRecipe
implements Recipe<Inventory>,
Comparable<FurnitureRecipe> {
    private final ResourceLocation id;
    final String group;
    final ItemStack output;
    final NonNullList<Ingredient> input;

    public FurnitureRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> input) {
        this.id = id;
        this.group = group;
        this.output = output;
        this.input = input;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    public boolean matches(Inventory playerInventory, Level world) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        BitSet hasIngredients = new BitSet(ingredients.size());
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        block0: for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            for (ItemStack stack : ingredient.m_43908_()) {
                int itemCount = 0;
                for (ItemStack stack1 : playerInventory.f_35974_) {
                    if (!stack.m_150930_(stack1.m_41720_())) continue;
                    itemCount += stack1.m_41613_();
                }
                if (itemCount == 0) continue block0;
                if (FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, stack) == -1) continue;
                if (!containedItems.containsKey(stack.m_41720_())) {
                    if (itemCount < stack.m_41613_()) continue;
                    hasIngredients.set(i, true);
                    containedItems.put(stack.m_41720_(), 1);
                    continue;
                }
                if (itemCount < (Integer)containedItems.get(stack.m_41720_()) + 1) continue;
                hasIngredients.set(i, true);
                containedItems.put(stack.m_41720_(), (Integer)containedItems.get(stack.m_41720_()) + 1);
            }
        }
        boolean matches = true;
        for (int i = 0; i < ingredients.size(); ++i) {
            if (hasIngredients.get(i)) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public static int getSlotWithStackIgnoreNBT(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (((ItemStack)inventory.f_35974_.get(i)).m_41619_() || !stack.m_150930_(((ItemStack)inventory.f_35974_.get(i)).m_41720_())) continue;
            return i;
        }
        return -1;
    }

    public ItemStack craft(Inventory playerInventory, RegistryAccess manager) {
        if (this.output.m_41783_() != null && this.output.m_41783_().m_128456_()) {
            ItemStack stack = this.output.m_41777_();
            stack.m_41751_(null);
            return stack;
        }
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess manager) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack m_8042_() {
        return PaladinFurnitureModBlocksItems.WORKING_TABLE.m_5456_().m_7968_();
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeTypes.FURNITURE_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.FURNITURE_RECIPE;
    }

    @Override
    public int compareTo(@NotNull FurnitureRecipe furnitureRecipe) {
        return this.output.toString().compareTo(furnitureRecipe.output.toString());
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FurnitureRecipe> {
        public FurnitureRecipe read(ResourceLocation identifier, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            NonNullList<Ingredient> defaultedList = Serializer.getIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (defaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for furniture recipe");
            }
            ItemStack itemStack = Serializer.outputFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new FurnitureRecipe(identifier, string, itemStack, defaultedList);
        }

        private static NonNullList<Ingredient> getIngredients(JsonArray json) {
            NonNullList defaultedList = NonNullList.m_122779_();
            for (int i = 0; i < json.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
                if (ingredient.m_43947_()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public static ItemStack outputFromJson(JsonObject json) {
            int i;
            Item item = Serializer.getItem(json);
            HashMap<String, Tag> elementList = null;
            if (json.has("tag")) {
                elementList = new HashMap<String, Tag>();
                for (Map.Entry jsonObject : json.get("tag").getAsJsonObject().entrySet()) {
                    elementList.put((String)jsonObject.getKey(), (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)jsonObject.getValue()));
                }
            }
            if ((i = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1)) < 1) {
                throw new JsonSyntaxException("Invalid output count: " + i);
            }
            ItemStack stack = new ItemStack((ItemLike)item, i);
            CompoundTag compound = new CompoundTag();
            if (elementList != null) {
                for (Map.Entry nbtElementEntry : elementList.entrySet()) {
                    compound.m_128365_((String)nbtElementEntry.getKey(), (Tag)nbtElementEntry.getValue());
                }
            }
            stack.m_41751_(compound);
            return stack;
        }

        public static Item getItem(JsonObject json) {
            String string = GsonHelper.m_13906_((JsonObject)json, (String)"item");
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
            if (item == Items.f_41852_) {
                throw new JsonSyntaxException("Invalid item: " + string);
            }
            return item;
        }

        public FurnitureRecipe read(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            String string = packetByteBuf.m_130277_();
            int i = packetByteBuf.m_130242_();
            NonNullList defaultedList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf));
            }
            ItemStack itemStack = packetByteBuf.m_130267_();
            return new FurnitureRecipe(identifier, string, itemStack, (NonNullList<Ingredient>)defaultedList);
        }

        public void write(FriendlyByteBuf packetByteBuf, FurnitureRecipe furnitureRecipe) {
            packetByteBuf.m_130070_(furnitureRecipe.group);
            packetByteBuf.m_130130_(furnitureRecipe.input.size());
            for (Ingredient ingredient : furnitureRecipe.input) {
                ingredient.m_43923_(packetByteBuf);
            }
            packetByteBuf.m_130055_(furnitureRecipe.output);
        }
    }
}

