/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class PFMLootTableProvider
extends PFMProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTypeGenerators = ImmutableList.of((Object)Pair.of(PFMLootTableGenerator::new, (Object)LootContextParamSets.f_81421_));

    public PFMLootTableProvider(PFMGenerator parent) {
        super(parent);
    }

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        Path path = this.getParent().getOutput();
        HashMap map = Maps.newHashMap();
        this.lootTypeGenerators.forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((identifier, builder) -> {
            if (map.put(identifier, builder.m_79165_((LootContextParamSet)pair.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + identifier);
            }
        }));
        map.forEach((identifier, lootTable) -> {
            Path path2 = PFMLootTableProvider.getOutput(path, identifier);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                Files.createFile(path2, new FileAttribute[0]);
                jsonWriter.setSerializeNulls(false);
                jsonWriter.setIndent("  ");
                GsonHelper.m_216207_((JsonWriter)jsonWriter, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(lootTable), (Comparator)f_236068_);
                jsonWriter.flush();
                Files.write(path2, byteArrayOutputStream.toByteArray(), StandardOpenOption.WRITE);
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                this.getParent().getLogger().error("Couldn't save {}", (Object)path2, (Object)exception);
            }
        });
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String m_6055_() {
        return "PFM Loot Tables";
    }

    private static Path getOutput(Path rootOutput, ResourceLocation lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.m_135827_() + "/loot_tables/" + lootTableId.m_135815_() + ".json");
    }

    static class PFMLootTableGenerator
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private final Map<ResourceLocation, LootTable.Builder> lootTables = Maps.newHashMap();
        private final List<Block> pfmBlocks = new ArrayList<Block>();

        PFMLootTableGenerator() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
            List<Block> blocks = PaladinFurnitureModBlocksItems.BLOCKS;
            blocks.forEach(this::addDrop);
            Block[] beds = PaladinFurnitureModBlocksItems.getBeds();
            Arrays.stream(beds).forEach(bed -> this.addDrop((Block)bed, (Block block) -> this.dropsWithProperty((Block)block, (Property)BedBlock.f_49440_, (Comparable<T> & StringRepresentable)BedPart.HEAD)));
            BasicBathtubBlock.basicBathtubBlockStream().forEach(basicBathtubBlock -> this.addDrop((Block)basicBathtubBlock, (Block block) -> this.dropsWithProperty((Block)block, (Property)BedBlock.f_49440_, (Comparable<T> & StringRepresentable)BedPart.HEAD)));
            HashSet set = Sets.newHashSet();
            for (Block block : this.pfmBlocks) {
                ResourceLocation identifier = block.m_60589_();
                if (identifier == BuiltInLootTables.f_78712_ || !set.add(identifier)) continue;
                LootTable.Builder builder5 = this.lootTables.remove(identifier);
                if (builder5 == null) {
                    throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", identifier, BuiltInRegistries.f_256975_.m_7981_((Object)block)));
                }
                biConsumer.accept(identifier, builder5);
            }
            if (!this.lootTables.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.lootTables.keySet());
            }
        }

        private void addDrop(Block block, Function<Block, LootTable.Builder> lootTableFunction) {
            this.addDrop(block, lootTableFunction.apply(block));
        }

        public void addDrop(Block block, Block drop) {
            this.addDrop(block, this.drops((ItemLike)drop));
        }

        public LootTable.Builder drops(ItemLike drop) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.addSurvivesExplosionCondition(drop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop))));
        }

        public void addDrop(Block block) {
            this.addDrop(block, block);
        }

        public final void addDrop(Block block, LootTable.Builder lootTable) {
            this.lootTables.put(block.m_60589_(), lootTable);
            this.pfmBlocks.add(block);
        }

        public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropsWithProperty(Block drop, Property<T> property, T value) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.addSurvivesExplosionCondition((ItemLike)drop, (ConditionUserBuilder<T>)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)drop).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)drop).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(property, value))))));
        }

        protected <T extends ConditionUserBuilder<T>> T addSurvivesExplosionCondition(ItemLike drop, ConditionUserBuilder<T> builder) {
            return (T)builder.m_79073_();
        }
    }
}

