/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portablemobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class PortableMobItemStackRenderer
implements CustomItemRenderer {
    public static final int ROTATION_TIME = 5000;

    public void render(ItemStack itemStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Entity living;
        BakedModel model = ClientUtils.getItemRenderer().m_115103_().m_109406_(itemStack);
        PortableMobItemStackRenderer.renderDefaultItem(itemStack, poseStack, transformType, bufferSource, combinedLight, combinedOverlay, model);
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128471_("has_entity")) {
            return;
        }
        CompoundTag compound = itemStack.m_41783_();
        Optional optional = EntityType.m_20632_((String)compound.m_128461_("entity_type"));
        if (optional.isPresent() && (living = ((EntityType)optional.get()).m_20615_(ClientUtils.getWorld())) != null) {
            living.m_20258_(compound.m_128469_("entity_data"));
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(new Quaternionf().setAngleAxis((double)((float)(System.currentTimeMillis() % 5000L) / 5000.0f * 2.0f) * Math.PI, 0.0, 1.0, 0.0));
            float width = living.m_20205_();
            float height = living.m_20206_();
            float size = 0.9f;
            float length = (float)Math.sqrt(2.0f * width * width + height * height) * 1.2f;
            float scalar = size / length;
            poseStack.m_85841_(scalar, scalar, scalar);
            PortableMobItemStackRenderer.renderEntity(living, poseStack, bufferSource, combinedLight);
            poseStack.m_85849_();
        }
    }

    private static <T extends Entity> void renderEntity(T living, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        EntityRenderer renderer = ClientUtils.getMinecraft().m_91290_().m_114382_(living);
        renderer.m_7392_(living, 0.0f, 0.0f, poseStack, bufferSource, combinedLight);
    }

    private static void renderDefaultItem(ItemStack itemStack, PoseStack poseStack, ItemDisplayContext cameraTransforms, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel model) {
        for (BakedModel passModel : model.getRenderPasses(itemStack, true)) {
            for (RenderType renderType : passModel.getRenderTypes(itemStack, true)) {
                VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.m_41790_());
                ClientUtils.getItemRenderer().m_115189_(passModel, itemStack, combinedLight, combinedOverlay, poseStack, vertexConsumer);
            }
        }
    }
}

