/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class UmbrellaItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"glider").stat(StatData.builder((String)"count").icon(StatIcons.COUNT).initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 3, 10).star(1, 11, 5).star(2, 19, 10).star(3, 11, 22).star(4, 15, 22).star(5, 13, 25).link(0, 1).link(1, 2).link(1, 3).link(3, 5).link(5, 4).build()).build()).ability(AbilityData.builder((String)"shield").requiredLevel(5).stat(StatData.builder((String)"knockback").icon(StatIcons.DISTANCE).initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 2, 5).star(1, 11, 3).star(2, 20, 6).star(3, 11, 13).star(4, 3, 19).star(5, 19, 19).star(6, 11, 25).link(0, 3).link(1, 3).link(2, 3).link(3, 4).link(4, 6).link(6, 5).link(3, 5).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charges = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
        if (player.onGround() && charges != 0) {
            stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)0);
        }
        if (player.isInWater() || !UmbrellaItem.isHoldingUmbrellaUpright((LivingEntity)player) || player.hasEffect(MobEffects.SLOW_FALLING) || player.getDeltaMovement().y > 0.0) {
            return;
        }
        Vec3 motion = player.getDeltaMovement();
        player.setDeltaMovement(motion.x, -0.15, motion.z);
        this.createParticle(level, player);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int charges = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
        int statCount = (int)this.getStatValue(stack, "glider", "count");
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)(charges + 1));
        if (!player.onGround()) {
            if (charges > statCount) {
                player.getCooldowns().addCooldown((Item)this, 120);
            } else {
                double modifierVal = 1.2;
                Vec3 lookDirection = player.getLookAngle().scale(-1.0);
                player.startUsingItem(hand);
                player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.MASTER, 0.5f, 1.0f + player.getRandom().nextFloat() * 0.25f);
                player.setDeltaMovement(new Vec3(lookDirection.x * modifierVal, lookDirection.y * modifierVal, lookDirection.z * modifierVal));
            }
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity, InteractionHand hand) {
        return entity.getItemInHand(hand).getItem() instanceof UmbrellaItem && (!entity.isUsingItem() || entity.getUsedItemHand() != hand);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity) {
        return UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.MAIN_HAND) || UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.OFF_HAND);
    }

    public void createParticle(Level level, Player player) {
        Vec3[] offsets;
        if (level.isClientSide || player.fallDistance < 2.0f) {
            return;
        }
        Vec3 basePosition = player.getEyePosition(1.0f).add(player.getLookAngle().scale(0.5)).add(player.getUpVector(1.0f).scale(-0.25)).add(player.getLookAngle().cross(new Vec3(0.0, 1.0, 0.0)).scale(player.getMainHandItem().getItem() instanceof UmbrellaItem ? 0.3 : -0.3));
        for (Vec3 offset : offsets = new Vec3[]{new Vec3(0.5, 0.0, 0.5), new Vec3(0.5, 0.0, -0.5), new Vec3(-0.5, 0.0, 0.5), new Vec3(-0.5, 0.0, -0.5)}) {
            Vec3 particlePosition = basePosition.add(offset);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, particlePosition.x, player.getY() + 3.0, particlePosition.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static class UmbrellaEvent {
        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            if (!UmbrellaItem.isHoldingUmbrellaUpright(event.getEntity())) {
                return;
            }
            event.setDamageMultiplier(0.0f);
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingIncomingDamageEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).getUseItem().getItem()) instanceof UmbrellaItem) {
                UmbrellaItem relic = (UmbrellaItem)livingEntity;
                if (player.isUsingItem() && (livingEntity = event.getSource().getEntity()) instanceof LivingEntity) {
                    LivingEntity attacker = livingEntity;
                    if (!player.level().isClientSide && attacker != player) {
                        event.setCanceled(true);
                        double radius = 2.0;
                        double height = 2.0;
                        Vec3 zoneCenter = player.position().add(player.getLookAngle().normalize().scale(1.0));
                        AABB boundingBox = new AABB(zoneCenter.x - radius, zoneCenter.y - height / 2.0, zoneCenter.z - radius, zoneCenter.x + radius, zoneCenter.y + height / 2.0, zoneCenter.z + radius);
                        List entitiesInRange = player.level().getEntitiesOfClass(LivingEntity.class, boundingBox, entity -> entity != player && entity.isAlive());
                        for (LivingEntity entity2 : entitiesInRange) {
                            Vec3 toEntity = entity2.position().subtract(player.position()).normalize().scale(relic.getStatValue(player.getUseItem(), "shield", "knockback"));
                            entity2.setDeltaMovement(toEntity.x, toEntity.y / 2.0, toEntity.z);
                            Vec3 startPosition = attacker.position().add(new Vec3(0.0, (double)attacker.getBbHeight() / 2.0, 0.0));
                            Vec3 particleVelocity = toEntity.normalize().scale(0.5);
                            ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, startPosition.x, startPosition.y, startPosition.z, 10, particleVelocity.x, particleVelocity.y, particleVelocity.z, 0.1);
                        }
                        player.level().playSound(null, player.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.MASTER, 0.3f, 1.0f + player.getRandom().nextFloat() * 0.25f);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingRender(RenderLivingEvent.Pre<?, ?> event) {
            boolean isRightHanded;
            Player player;
            block6: {
                block5: {
                    EntityModel entityModel = event.getRenderer().getModel();
                    if (!(entityModel instanceof HumanoidModel)) break block5;
                    HumanoidModel humanoidModel = (HumanoidModel)entityModel;
                    entityModel = event.getEntity();
                    if (entityModel instanceof Player && UmbrellaItem.isHoldingUmbrellaUpright((LivingEntity)(player = (Player)entityModel))) break block6;
                }
                return;
            }
            boolean isHoldingOffHand = UmbrellaItem.isHoldingUmbrellaUpright((LivingEntity)player, InteractionHand.OFF_HAND);
            boolean isHoldingMainHand = UmbrellaItem.isHoldingUmbrellaUpright((LivingEntity)player, InteractionHand.MAIN_HAND);
            boolean bl = isRightHanded = player.getMainArm() == HumanoidArm.RIGHT;
            if (isHoldingMainHand && isRightHanded || isHoldingOffHand && !isRightHanded) {
                humanoidModel.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (isHoldingMainHand && !isRightHanded || isHoldingOffHand && isRightHanded) {
                humanoidModel.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
    }
}

