/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.belt;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

public class CrystalHeartItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heart").stat(StatData.builder((String)"amount").icon(StatIcons.CAPACITY).initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 6, 12).star(1, 16, 12).star(2, 11, 22).link(0, 1).link(1, 2).link(2, 0).link(1, 0).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.BASTION).build()).build();
    }

    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.MAX_HEALTH, (float)this.getStatValue(stack, "heart", "amount"), AttributeModifier.Operation.ADD_VALUE)).build();
    }

    @EventBusSubscriber
    public static class CrystalHeartEvent {
        @SubscribeEvent
        public static void onLivingHealEvent(LivingHealEvent event) {
            CrystalHeartItem relic;
            Item item;
            ItemStack stack;
            block5: {
                block4: {
                    stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)((Item)ModItems.CRYSTAL_HEART.value()));
                    item = stack.getItem();
                    if (!(item instanceof CrystalHeartItem)) break block4;
                    relic = (CrystalHeartItem)item;
                    item = event.getEntity();
                    if (item instanceof Player) break block5;
                }
                return;
            }
            Player player = (Player)item;
            float currentHealth = player.getHealth();
            float maxHealth = player.getMaxHealth();
            if (Math.random() < Math.max(0.1, (double)((maxHealth - currentHealth) / maxHealth))) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

