/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.belt;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class OnionRingItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"onion").stat(StatData.builder((String)"amount").icon(StatIcons.MODIFIER).initialValue(0.02, 0.05).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 11, 25).star(1, 5, 21).star(2, 3, 14).star(3, 5, 7).star(4, 11, 4).star(5, 17, 7).star(6, 19, 14).star(7, 17, 21).star(8, 6, 11).star(9, 11, 10).star(10, 16, 11).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 0).link(0, 9).link(8, 9).link(9, 10).link(2, 8).link(10, 6).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    @EventBusSubscriber
    public static class Event {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.value()));
            Item item = stack.getItem();
            if (!(item instanceof OnionRingItem)) {
                return;
            }
            OnionRingItem relic = (OnionRingItem)item;
            int currentHunger = player.getFoodData().getFoodLevel();
            double modifier = relic.getStatValue(stack, "onion", "amount");
            event.setNewSpeed((float)((double)event.getNewSpeed() + (double)event.getNewSpeed() * ((double)currentHunger * modifier)));
        }

        @SubscribeEvent
        public static void onBlockDestroy(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.value()));
            Item item = stack.getItem();
            if (!(item instanceof OnionRingItem)) {
                return;
            }
            OnionRingItem relic = (OnionRingItem)item;
            float hardness = event.getState().getDestroySpeed((BlockGetter)player.level(), player.blockPosition());
            float currentHunger = player.getFoodData().getFoodLevel();
            if ((double)hardness >= 0.5) {
                Random random = new Random();
                if (currentHunger / 20.0f >= random.nextFloat(1.0f)) {
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            }
        }
    }
}

