/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.curios.api.SlotContext;

public class SnowshoesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"speed").stat(StatData.builder((String)"amount").icon(StatIcons.SPEED).initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 6, 7).star(1, 11, 3).star(2, 16, 8).star(3, 15, 16).star(4, 14, 25).star(5, 8, 25).star(6, 9, 17).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 0).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.onGround() && this.isStandingOnSnow(player)) {
            if (player.tickCount % 60 == 0 && (player.getKnownMovement().x != 0.0 || player.getKnownMovement().z != 0.0)) {
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)((float)this.getStatValue(stack, "speed", "amount")), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }
    }

    private boolean isStandingOnSnow(Player player) {
        BlockState blockBelow = player.level().getBlockState(player.blockPosition().below());
        return player.onGround() && (blockBelow.is(Blocks.SNOW_BLOCK) || blockBelow.is(Blocks.POWDER_SNOW) || player.level().getBlockState(player.blockPosition()).is(Blocks.SNOW));
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (newStack.getItem() == stack.getItem()) {
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }
}

