/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import org.jetbrains.annotations.Nullable;

public class SteadfastSpikesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"resistance").stat(StatData.builder((String)"modifier").icon(StatIcons.RESISTANCE).initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.JUNGLE).build()).build();
    }

    @Nullable
    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.KNOCKBACK_RESISTANCE, (float)this.getStatValue(stack, "resistance", "modifier"))).build();
    }

    @EventBusSubscriber
    public static class SteadfastSpikesEvent {
        @SubscribeEvent
        public static void onLivingKnockBack(LivingKnockBackEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.STEADFAST_SPIKES.value()));
            Item item = stack.getItem();
            if (!(item instanceof SteadfastSpikesItem)) {
                return;
            }
            SteadfastSpikesItem relic = (SteadfastSpikesItem)item;
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }

        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            Player player;
            LivingEntity livingEntity;
            if (event.getFriction() <= 0.6f || !((livingEntity = event.getEntity()) instanceof Player) || (player = (Player)livingEntity).isInWater() || player.isInLava()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.STEADFAST_SPIKES.value()));
            Item item = stack.getItem();
            if (!(item instanceof SteadfastSpikesItem)) {
                return;
            }
            SteadfastSpikesItem relic = (SteadfastSpikesItem)item;
            if (player.tickCount % 60 == 0 && player.onGround() && (player.getKnownMovement().x != 0.0 || player.getKnownMovement().z != 0.0)) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            event.setFriction((float)((double)event.getFriction() * (1.0 - relic.getStatValue(stack, "resistance", "modifier") / 3.0)));
        }
    }
}

