/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class DiggingClawsItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"claws").stat(StatData.builder((String)"amount").icon(StatIcons.COUNT).initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 4, 15).star(1, 12, 3).star(2, 6, 19).star(3, 16, 6).star(4, 9, 23).star(5, 17, 12).star(6, 13, 24).star(7, 17, 18).link(0, 1).link(2, 3).link(4, 5).link(6, 7).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    @EventBusSubscriber
    public static class DiggingClawsEvent {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.DIGGING_CLAWS.value()));
            Item item = stack.getItem();
            if (!(item instanceof DiggingClawsItem)) {
                return;
            }
            DiggingClawsItem relic = (DiggingClawsItem)item;
            event.setNewSpeed((float)((double)event.getOriginalSpeed() + relic.getStatValue(stack, "claws", "amount")));
        }

        @SubscribeEvent
        public static void onBlockDestroy(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.DIGGING_CLAWS.value()));
            Item item = stack.getItem();
            if (!(item instanceof DiggingClawsItem)) {
                return;
            }
            DiggingClawsItem relic = (DiggingClawsItem)item;
            float hardness = event.getState().getDestroySpeed((BlockGetter)player.level(), player.blockPosition());
            Random random = new Random();
            if (random.nextFloat(1.0f) <= hardness / 20.0f) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

