/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import top.theillusivec4.curios.api.SlotContext;

public class FeralClawsItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"claws").stat(StatData.builder((String)"modifier").icon(StatIcons.MODIFIER).initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.12).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 4, 15).star(1, 12, 3).star(2, 6, 19).star(3, 16, 6).star(4, 9, 23).star(5, 17, 12).star(6, 13, 24).star(7, 17, 18).link(0, 1).link(2, 3).link(4, 5).link(6, 7).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block8: {
            block7: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block7;
                player = (Player)livingEntity;
                if (player.tickCount % 20 == 0) break block8;
            }
            return;
        }
        FeralClawsItem.addTime(stack, 1);
        int time = FeralClawsItem.getTime(stack);
        int attackCount = FeralClawsItem.getAttackCount(stack);
        if (player.getAttackStrengthScale(0.0f) != 1.0f) {
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            FeralClawsItem.addAttackCount(stack, -attackCount);
        }
        if (time >= 3) {
            if (attackCount <= 0) {
                EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            }
            if (time % 3 == 0 && attackCount > 0) {
                FeralClawsItem.addAttackCount(stack, -1);
                FeralClawsItem.resetAttribute(player, stack, this);
            }
            FeralClawsItem.addTime(stack, -time);
        }
    }

    public static void resetAttribute(Player player, ItemStack stack, FeralClawsItem relic) {
        EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (float)((float)((double)FeralClawsItem.getAttackCount(stack) * relic.getStatValue(stack, "claws", "modifier"))), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public static void addTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0) + val));
    }

    public static int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public static void addAttackCount(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.COUNT, (Object)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)0) + val));
    }

    public static int getAttackCount(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)0);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (newStack.getItem() != stack.getItem()) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    @EventBusSubscriber
    public static class FeralClawsEvent {
        @SubscribeEvent
        public static void onPlayerAttack(AttackEntityEvent event) {
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.FERAL_CLAWS.value()));
            Item item = stack.getItem();
            if (!(item instanceof FeralClawsItem)) {
                return;
            }
            FeralClawsItem relic = (FeralClawsItem)item;
            if (player.getAttackStrengthScale(0.0f) != 1.0f) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            FeralClawsItem.addAttackCount(stack, 1);
            FeralClawsItem.addTime(stack, -FeralClawsItem.getTime(stack));
            FeralClawsItem.resetAttribute(player, stack, relic);
        }
    }
}

